import statsmodels.base.model as base
import statsmodels.regression.linear_model as lm
from statsmodels.discrete.discrete_model import MultinomialResults as MultinomialResults, MultinomialResultsWrapper as MultinomialResultsWrapper
from typing import Any

class _ConditionalModel(base.LikelihoodModel):
    k_params: Any
    nobs: int
    def __init__(self, endog, exog, missing: str = ..., **kwargs) -> None: ...
    def hessian(self, params): ...
    def fit(self, start_params: Any | None = ..., method: str = ..., maxiter: int = ..., full_output: bool = ..., disp: bool = ..., fargs=..., callback: Any | None = ..., retall: bool = ..., skip_hessian: bool = ..., **kwargs): ...
    def fit_regularized(self, method: str = ..., alpha: float = ..., start_params: Any | None = ..., refit: bool = ..., **kwargs): ...
    @classmethod
    def from_formula(cls, formula, data, subset: Any | None = ..., drop_cols: Any | None = ..., *args, **kwargs): ...

class ConditionalLogit(_ConditionalModel):
    K: Any
    def __init__(self, endog, exog, missing: str = ..., **kwargs) -> None: ...
    def loglike(self, params): ...
    def score(self, params): ...
    def loglike_grp(self, grp, params): ...
    def score_grp(self, grp, params): ...

class ConditionalPoisson(_ConditionalModel):
    def loglike(self, params): ...
    def score(self, params): ...

class ConditionalResults(base.LikelihoodModelResults):
    def __init__(self, model, params, normalized_cov_params, scale) -> None: ...
    def summary(self, yname: Any | None = ..., xname: Any | None = ..., title: Any | None = ..., alpha: float = ...): ...

class ConditionalMNLogit(_ConditionalModel):
    endog: Any
    k_cat: Any
    df_model: Any
    df_resid: Any
    J: Any
    K: Any
    def __init__(self, endog, exog, missing: str = ..., **kwargs) -> None: ...
    def fit(self, start_params: Any | None = ..., method: str = ..., maxiter: int = ..., full_output: bool = ..., disp: bool = ..., fargs=..., callback: Any | None = ..., retall: bool = ..., skip_hessian: bool = ..., **kwargs): ...
    def loglike(self, params): ...
    def score(self, params): ...

class ConditionalResultsWrapper(lm.RegressionResultsWrapper): ...
