from statsmodels.compat.python import lmap as lmap
from statsmodels.tools.decorators import cache_readonly as cache_readonly, cache_writable as cache_writable
from statsmodels.tools.sm_exceptions import MissingDataError as MissingDataError
from typing import Any

class ModelData:
    design_info: Any
    formula: Any
    missing_row_idx: Any
    orig_endog: Any
    orig_exog: Any
    const_idx: Any
    k_constant: int
    def __init__(self, endog, exog: Any | None = ..., missing: str = ..., hasconst: Any | None = ..., **kwargs) -> None: ...
    @classmethod
    def handle_missing(cls, endog, exog, missing, **kwargs): ...
    def ynames(self): ...
    def xnames(self): ...
    @property
    def param_names(self): ...
    @param_names.setter
    def param_names(self, values) -> None: ...
    @property
    def cov_names(self): ...
    @cov_names.setter
    def cov_names(self, value) -> None: ...
    def row_labels(self): ...
    def wrap_output(self, obj, how: str = ..., names: Any | None = ...): ...
    def attach_columns(self, result): ...
    def attach_columns_eq(self, result): ...
    def attach_cov(self, result): ...
    def attach_cov_eq(self, result): ...
    def attach_rows(self, result): ...
    def attach_dates(self, result): ...
    def attach_mv_confint(self, result): ...
    def attach_generic_columns(self, result, *args, **kwargs): ...
    def attach_generic_columns_2d(self, result, *args, **kwargs): ...
    def attach_ynames(self, result): ...

class PatsyData(ModelData): ...

class PandasData(ModelData):
    def attach_generic_columns(self, result, names): ...
    def attach_generic_columns_2d(self, result, rownames, colnames: Any | None = ...): ...
    def attach_columns(self, result): ...
    def attach_columns_eq(self, result): ...
    def attach_cov(self, result): ...
    def attach_cov_eq(self, result): ...
    def attach_rows(self, result): ...
    def attach_dates(self, result): ...
    def attach_mv_confint(self, result): ...
    def attach_ynames(self, result): ...

def handle_missing(endog, exog: Any | None = ..., missing: str = ..., **kwargs): ...
def handle_data_class_factory(endog, exog): ...
def handle_data(endog, exog, missing: str = ..., hasconst: Any | None = ..., **kwargs): ...
