from sklearn.base import BaseEstimator as BaseEstimator, ClassifierMixin as ClassifierMixin
from sklearn.cluster import MiniBatchKMeans as MiniBatchKMeans
from sklearn.datasets import make_multilabel_classification as make_multilabel_classification
from sklearn.decomposition import PCA as PCA
from sklearn.ensemble import ExtraTreesClassifier as ExtraTreesClassifier
from sklearn.exceptions import SkipTestWarning as SkipTestWarning
from sklearn.linear_model import LinearRegression as LinearRegression, LogisticRegression as LogisticRegression, MultiTaskElasticNet as MultiTaskElasticNet, SGDClassifier as SGDClassifier
from sklearn.mixture import GaussianMixture as GaussianMixture
from sklearn.neighbors import KNeighborsRegressor as KNeighborsRegressor
from sklearn.svm import NuSVC as NuSVC, SVC as SVC
from sklearn.utils import all_estimators as all_estimators, deprecated as deprecated
from sklearn.utils._testing import MinimalClassifier as MinimalClassifier, MinimalRegressor as MinimalRegressor, MinimalTransformer as MinimalTransformer, SkipTest as SkipTest, ignore_warnings as ignore_warnings, raises as raises
from sklearn.utils.estimator_checks import check_class_weight_balanced_linear_classifier as check_class_weight_balanced_linear_classifier, check_classifier_data_not_an_array as check_classifier_data_not_an_array, check_classifiers_multilabel_output_format_decision_function as check_classifiers_multilabel_output_format_decision_function, check_classifiers_multilabel_output_format_predict as check_classifiers_multilabel_output_format_predict, check_classifiers_multilabel_output_format_predict_proba as check_classifiers_multilabel_output_format_predict_proba, check_dataframe_column_names_consistency as check_dataframe_column_names_consistency, check_estimator as check_estimator, check_estimator_get_tags_default_keys as check_estimator_get_tags_default_keys, check_estimators_unfitted as check_estimators_unfitted, check_fit_check_is_fitted as check_fit_check_is_fitted, check_fit_score_takes_y as check_fit_score_takes_y, check_no_attributes_set_in_init as check_no_attributes_set_in_init, check_outlier_corruption as check_outlier_corruption, check_regressor_data_not_an_array as check_regressor_data_not_an_array, set_random_state as set_random_state
from sklearn.utils.fixes import np_version as np_version, parse_version as parse_version
from sklearn.utils.metaestimators import available_if as available_if
from sklearn.utils.validation import check_array as check_array, check_is_fitted as check_is_fitted
from typing import Any

class CorrectNotFittedError(ValueError): ...

class BaseBadClassifier(ClassifierMixin, BaseEstimator):
    def fit(self, X, y): ...
    def predict(self, X): ...

class ChangesDict(BaseEstimator):
    key: Any
    def __init__(self, key: int = ...) -> None: ...
    def fit(self, X, y: Any | None = ...): ...
    def predict(self, X): ...

class SetsWrongAttribute(BaseEstimator):
    acceptable_key: Any
    def __init__(self, acceptable_key: int = ...) -> None: ...
    wrong_attribute: int
    def fit(self, X, y: Any | None = ...): ...

class ChangesWrongAttribute(BaseEstimator):
    wrong_attribute: Any
    def __init__(self, wrong_attribute: int = ...) -> None: ...
    def fit(self, X, y: Any | None = ...): ...

class ChangesUnderscoreAttribute(BaseEstimator):
    def fit(self, X, y: Any | None = ...): ...

class RaisesErrorInSetParams(BaseEstimator):
    p: Any
    def __init__(self, p: int = ...) -> None: ...
    def set_params(self, **kwargs): ...
    def fit(self, X, y: Any | None = ...): ...

class HasMutableParameters(BaseEstimator):
    p: Any
    def __init__(self, p=...) -> None: ...
    def fit(self, X, y: Any | None = ...): ...

class HasImmutableParameters(BaseEstimator):
    p: Any
    q: Any
    r: Any
    def __init__(self, p: int = ..., q=..., r=...) -> None: ...
    def fit(self, X, y: Any | None = ...): ...

class ModifiesValueInsteadOfRaisingError(BaseEstimator):
    p: Any
    def __init__(self, p: int = ...) -> None: ...
    def set_params(self, **kwargs): ...
    def fit(self, X, y: Any | None = ...): ...

class ModifiesAnotherValue(BaseEstimator):
    a: Any
    b: Any
    def __init__(self, a: int = ..., b: str = ...) -> None: ...
    def set_params(self, **kwargs): ...
    def fit(self, X, y: Any | None = ...): ...

class NoCheckinPredict(BaseBadClassifier):
    def fit(self, X, y): ...

class NoSparseClassifier(BaseBadClassifier):
    def fit(self, X, y): ...
    def predict(self, X): ...

class CorrectNotFittedErrorClassifier(BaseBadClassifier):
    coef_: Any
    def fit(self, X, y): ...
    def predict(self, X): ...

class NoSampleWeightPandasSeriesType(BaseEstimator):
    def fit(self, X, y, sample_weight: Any | None = ...): ...
    def predict(self, X): ...

class BadBalancedWeightsClassifier(BaseBadClassifier):
    class_weight: Any
    def __init__(self, class_weight: Any | None = ...) -> None: ...
    coef_: Any
    def fit(self, X, y): ...

class BadTransformerWithoutMixin(BaseEstimator):
    def fit(self, X, y: Any | None = ...): ...
    def transform(self, X): ...

class NotInvariantPredict(BaseEstimator):
    def fit(self, X, y): ...
    def predict(self, X): ...

class NotInvariantSampleOrder(BaseEstimator):
    def fit(self, X, y): ...
    def predict(self, X): ...

class LargeSparseNotSupportedClassifier(BaseEstimator):
    def fit(self, X, y): ...

class SparseTransformer(BaseEstimator):
    X_shape_: Any
    def fit(self, X, y: Any | None = ...): ...
    def fit_transform(self, X, y: Any | None = ...): ...
    def transform(self, X): ...

class EstimatorInconsistentForPandas(BaseEstimator):
    value_: Any
    def fit(self, X, y): ...
    def predict(self, X): ...

class UntaggedBinaryClassifier(SGDClassifier):
    def fit(self, X, y, coef_init: Any | None = ..., intercept_init: Any | None = ..., sample_weight: Any | None = ...): ...
    def partial_fit(self, X, y, classes: Any | None = ..., sample_weight: Any | None = ...): ...

class TaggedBinaryClassifier(UntaggedBinaryClassifier): ...
class EstimatorMissingDefaultTags(BaseEstimator): ...

class RequiresPositiveYRegressor(LinearRegression):
    def fit(self, X, y): ...

class PoorScoreLogisticRegression(LogisticRegression):
    def decision_function(self, X): ...

class PartialFitChecksName(BaseEstimator):
    def fit(self, X, y): ...
    def partial_fit(self, X, y): ...

def test_not_an_array_array_function() -> None: ...
def test_check_fit_score_takes_y_works_on_deprecated_fit(): ...
def test_check_estimator() -> None: ...
def test_check_outlier_corruption() -> None: ...
def test_check_estimator_transformer_no_mixin() -> None: ...
def test_check_estimator_clones() -> None: ...
def test_check_estimators_unfitted() -> None: ...
def test_check_no_attributes_set_in_init() -> None: ...
def test_check_estimator_pairwise() -> None: ...
def test_check_classifier_data_not_an_array() -> None: ...
def test_check_regressor_data_not_an_array() -> None: ...
def test_check_estimator_get_tags_default_keys() -> None: ...
def test_check_dataframe_column_names_consistency() -> None: ...

class _BaseMultiLabelClassifierMock(ClassifierMixin, BaseEstimator):
    response_output: Any
    def __init__(self, response_output) -> None: ...
    def fit(self, X, y): ...

def test_check_classifiers_multilabel_output_format_predict(): ...
def test_check_classifiers_multilabel_output_format_predict_proba(): ...
def test_check_classifiers_multilabel_output_format_decision_function(): ...
def run_tests_without_pytest() -> None: ...
def test_check_class_weight_balanced_linear_classifier() -> None: ...
def test_all_estimators_all_public() -> None: ...
def test_xfail_ignored_in_check_estimator() -> None: ...
def test_minimal_class_implementation_checks() -> None: ...
def test_check_fit_check_is_fitted(): ...
