from ..base import BaseEstimator, TransformerMixin, _OneToOneFeatureMixin
from ._encoders import OneHotEncoder as OneHotEncoder
from typing import Any
import numpy

def scale(X, *, axis: int = ..., with_mean: bool = ..., with_std: bool = ..., copy: bool = ...): ...

class MinMaxScaler(_OneToOneFeatureMixin, TransformerMixin, BaseEstimator):
    feature_range: Any
    copy: Any
    clip: Any
    def __init__(self, feature_range=..., *, copy: bool = ..., clip: bool = ...) -> None: ...
    def fit(self, X, y: Any | None = ...) -> MinMaxScaler: ...
    n_samples_seen_: Any
    scale_: Any
    min_: Any
    data_min_: Any
    data_max_: Any
    data_range_: Any
    def partial_fit(self, X, y: Any | None = ...): ...
    def transform(self, X) -> numpy.ndarray: ...
    def inverse_transform(self, X): ...

def minmax_scale(X, feature_range=..., *, axis: int = ..., copy: bool = ...): ...

class StandardScaler(_OneToOneFeatureMixin, TransformerMixin, BaseEstimator):
    with_mean: Any
    with_std: Any
    copy: Any
    def __init__(self, *, copy: bool = ..., with_mean: bool = ..., with_std: bool = ...) -> None: ...
    def fit(self, X, y: Any | None = ..., sample_weight: Any | None = ...) -> StandardScaler: ...
    n_samples_seen_: Any
    mean_: Any
    var_: Any
    scale_: Any
    def partial_fit(self, X, y: Any | None = ..., sample_weight: Any | None = ...): ...
    def transform(self, X, copy: Any | None = ...) -> numpy.ndarray: ...
    def inverse_transform(self, X, copy: Any | None = ...): ...

class MaxAbsScaler(_OneToOneFeatureMixin, TransformerMixin, BaseEstimator):
    copy: Any
    def __init__(self, *, copy: bool = ...) -> None: ...
    def fit(self, X, y: Any | None = ...): ...
    n_samples_seen_: Any
    max_abs_: Any
    scale_: Any
    def partial_fit(self, X, y: Any | None = ...): ...
    def transform(self, X) -> numpy.ndarray: ...
    def inverse_transform(self, X): ...

def maxabs_scale(X, *, axis: int = ..., copy: bool = ...): ...

class RobustScaler(_OneToOneFeatureMixin, TransformerMixin, BaseEstimator):
    with_centering: Any
    with_scaling: Any
    quantile_range: Any
    unit_variance: Any
    copy: Any
    def __init__(self, *, with_centering: bool = ..., with_scaling: bool = ..., quantile_range=..., copy: bool = ..., unit_variance: bool = ...) -> None: ...
    center_: Any
    scale_: Any
    def fit(self, X, y: Any | None = ...): ...
    def transform(self, X) -> numpy.ndarray: ...
    def inverse_transform(self, X): ...

def robust_scale(X, *, axis: int = ..., with_centering: bool = ..., with_scaling: bool = ..., quantile_range=..., copy: bool = ..., unit_variance: bool = ...): ...
def normalize(X, norm: str = ..., *, axis: int = ..., copy: bool = ..., return_norm: bool = ...): ...

class Normalizer(TransformerMixin, BaseEstimator):
    norm: Any
    copy: Any
    def __init__(self, norm: str = ..., *, copy: bool = ...) -> None: ...
    def fit(self, X, y: Any | None = ...): ...
    def transform(self, X, copy: Any | None = ...) -> numpy.ndarray: ...

def binarize(X, *, threshold: float = ..., copy: bool = ...): ...

class Binarizer(TransformerMixin, BaseEstimator):
    threshold: Any
    copy: Any
    def __init__(self, *, threshold: float = ..., copy: bool = ...) -> None: ...
    def fit(self, X, y: Any | None = ...): ...
    def transform(self, X, copy: Any | None = ...) -> numpy.ndarray: ...

class KernelCenterer(TransformerMixin, BaseEstimator):
    def __init__(self) -> None: ...
    K_fit_rows_: Any
    K_fit_all_: Any
    def fit(self, K, y: Any | None = ...): ...
    def transform(self, K, copy: bool = ...) -> numpy.ndarray: ...

def add_dummy_feature(X, value: float = ...): ...

class QuantileTransformer(_OneToOneFeatureMixin, TransformerMixin, BaseEstimator):
    n_quantiles: Any
    output_distribution: Any
    ignore_implicit_zeros: Any
    subsample: Any
    random_state: Any
    copy: Any
    def __init__(self, *, n_quantiles: int = ..., output_distribution: str = ..., ignore_implicit_zeros: bool = ..., subsample=..., random_state: Any | None = ..., copy: bool = ...) -> None: ...
    n_quantiles_: Any
    references_: Any
    def fit(self, X, y: Any | None = ...): ...
    def transform(self, X) -> numpy.ndarray: ...
    def inverse_transform(self, X): ...

def quantile_transform(X, *, axis: int = ..., n_quantiles: int = ..., output_distribution: str = ..., ignore_implicit_zeros: bool = ..., subsample=..., random_state: Any | None = ..., copy: bool = ...): ...

class PowerTransformer(_OneToOneFeatureMixin, TransformerMixin, BaseEstimator):
    method: Any
    standardize: Any
    copy: Any
    def __init__(self, method: str = ..., *, standardize: bool = ..., copy: bool = ...) -> None: ...
    def fit(self, X, y: Any | None = ...): ...
    def fit_transform(self, X, y: Any | None = ...): ...
    def transform(self, X) -> numpy.ndarray: ...
    def inverse_transform(self, X): ...

def power_transform(X, method: str = ..., *, standardize: bool = ..., copy: bool = ...): ...
