from ..base import ClassifierMixin as ClassifierMixin
from ..utils.extmath import weighted_mode as weighted_mode
from ._base import KNeighborsMixin as KNeighborsMixin, NeighborsBase as NeighborsBase, RadiusNeighborsMixin as RadiusNeighborsMixin
from typing import Any

class KNeighborsClassifier(KNeighborsMixin, ClassifierMixin, NeighborsBase):
    weights: Any
    def __init__(self, n_neighbors: int = ..., *, weights: str = ..., algorithm: str = ..., leaf_size: int = ..., p: int = ..., metric: str = ..., metric_params: Any | None = ..., n_jobs: Any | None = ...) -> None: ...
    def fit(self, X, y): ...
    def predict(self, X): ...
    def predict_proba(self, X): ...

class RadiusNeighborsClassifier(RadiusNeighborsMixin, ClassifierMixin, NeighborsBase):
    weights: Any
    outlier_label: Any
    def __init__(self, radius: float = ..., *, weights: str = ..., algorithm: str = ..., leaf_size: int = ..., p: int = ..., metric: str = ..., outlier_label: Any | None = ..., metric_params: Any | None = ..., n_jobs: Any | None = ..., **kwargs) -> None: ...
    outlier_label_: Any
    def fit(self, X, y): ...
    def predict(self, X): ...
    def predict_proba(self, X): ...
