import abc
from .base import BaseEstimator, ClassifierMixin
from abc import ABCMeta
from typing import Any

class _BaseNB(ClassifierMixin, BaseEstimator, metaclass=ABCMeta):
    def predict(self, X): ...
    def predict_log_proba(self, X): ...
    def predict_proba(self, X): ...

class GaussianNB(_BaseNB):
    priors: Any
    var_smoothing: Any
    def __init__(self, *, priors: Any | None = ..., var_smoothing: float = ...) -> None: ...
    def fit(self, X, y, sample_weight: Any | None = ...): ...
    def partial_fit(self, X, y, classes: Any | None = ..., sample_weight: Any | None = ...): ...
    @property
    def sigma_(self): ...

class _BaseDiscreteNB(_BaseNB, metaclass=abc.ABCMeta):
    def partial_fit(self, X, y, classes: Any | None = ..., sample_weight: Any | None = ...): ...
    classes_: Any
    def fit(self, X, y, sample_weight: Any | None = ...): ...
    @property
    def coef_(self): ...
    @property
    def intercept_(self): ...
    @property
    def n_features_(self): ...

class MultinomialNB(_BaseDiscreteNB):
    alpha: Any
    fit_prior: Any
    class_prior: Any
    def __init__(self, *, alpha: float = ..., fit_prior: bool = ..., class_prior: Any | None = ...) -> None: ...

class ComplementNB(_BaseDiscreteNB):
    alpha: Any
    fit_prior: Any
    class_prior: Any
    norm: Any
    def __init__(self, *, alpha: float = ..., fit_prior: bool = ..., class_prior: Any | None = ..., norm: bool = ...) -> None: ...

class BernoulliNB(_BaseDiscreteNB):
    alpha: Any
    binarize: Any
    fit_prior: Any
    class_prior: Any
    def __init__(self, *, alpha: float = ..., binarize: float = ..., fit_prior: bool = ..., class_prior: Any | None = ...) -> None: ...

class CategoricalNB(_BaseDiscreteNB):
    alpha: Any
    fit_prior: Any
    class_prior: Any
    min_categories: Any
    def __init__(self, *, alpha: float = ..., fit_prior: bool = ..., class_prior: Any | None = ..., min_categories: Any | None = ...) -> None: ...
    def fit(self, X, y, sample_weight: Any | None = ...): ...
    def partial_fit(self, X, y, classes: Any | None = ..., sample_weight: Any | None = ...): ...
