from sklearn.base import BaseEstimator as BaseEstimator, clone as clone
from sklearn.cluster import KMeans as KMeans
from sklearn.datasets import load_diabetes as load_diabetes, load_digits as load_digits, load_iris as load_iris, make_classification as make_classification, make_multilabel_classification as make_multilabel_classification, make_regression as make_regression
from sklearn.ensemble import RandomForestClassifier as RandomForestClassifier
from sklearn.exceptions import FitFailedWarning as FitFailedWarning
from sklearn.impute import SimpleImputer as SimpleImputer
from sklearn.linear_model import LogisticRegression as LogisticRegression, PassiveAggressiveClassifier as PassiveAggressiveClassifier, Ridge as Ridge, RidgeClassifier as RidgeClassifier, SGDClassifier as SGDClassifier
from sklearn.metrics import accuracy_score as accuracy_score, check_scoring as check_scoring, confusion_matrix as confusion_matrix, explained_variance_score as explained_variance_score, make_scorer as make_scorer, mean_squared_error as mean_squared_error, precision_recall_fscore_support as precision_recall_fscore_support, precision_score as precision_score, r2_score as r2_score
from sklearn.model_selection import GridSearchCV as GridSearchCV, GroupKFold as GroupKFold, GroupShuffleSplit as GroupShuffleSplit, KFold as KFold, LeaveOneGroupOut as LeaveOneGroupOut, LeaveOneOut as LeaveOneOut, LeavePGroupsOut as LeavePGroupsOut, ShuffleSplit as ShuffleSplit, StratifiedKFold as StratifiedKFold, cross_val_predict as cross_val_predict, cross_val_score as cross_val_score, cross_validate as cross_validate, learning_curve as learning_curve, permutation_test_score as permutation_test_score, validation_curve as validation_curve
from sklearn.model_selection.tests.common import OneTimeSplitter as OneTimeSplitter
from sklearn.model_selection.tests.test_search import FailingClassifier as FailingClassifier
from sklearn.multiclass import OneVsRestClassifier as OneVsRestClassifier
from sklearn.neighbors import KNeighborsClassifier as KNeighborsClassifier
from sklearn.pipeline import Pipeline as Pipeline
from sklearn.preprocessing import LabelEncoder as LabelEncoder
from sklearn.svm import LinearSVC as LinearSVC, SVC as SVC
from sklearn.utils import shuffle as shuffle
from sklearn.utils._mocking import CheckingClassifier as CheckingClassifier, MockDataFrame as MockDataFrame
from sklearn.utils._testing import assert_allclose as assert_allclose, assert_almost_equal as assert_almost_equal, assert_array_almost_equal as assert_array_almost_equal, assert_array_equal as assert_array_equal
from typing import Any

WindowsError: Any

class MockImprovingEstimator(BaseEstimator):
    n_max_train_sizes: Any
    train_sizes: int
    X_subset: Any
    def __init__(self, n_max_train_sizes) -> None: ...
    def fit(self, X_subset, y_subset: Any | None = ...): ...
    def predict(self, X) -> None: ...
    def score(self, X: Any | None = ..., Y: Any | None = ...): ...

class MockIncrementalImprovingEstimator(MockImprovingEstimator):
    x: Any
    expected_fit_params: Any
    def __init__(self, n_max_train_sizes, expected_fit_params: Any | None = ...) -> None: ...
    def partial_fit(self, X, y: Any | None = ..., **params) -> None: ...

class MockEstimatorWithParameter(BaseEstimator):
    X_subset: Any
    param: Any
    def __init__(self, param: float = ...) -> None: ...
    train_sizes: Any
    def fit(self, X_subset, y_subset): ...
    def predict(self, X) -> None: ...
    def score(self, X: Any | None = ..., y: Any | None = ...): ...

class MockEstimatorWithSingleFitCallAllowed(MockEstimatorWithParameter):
    fit_called_: bool
    def fit(self, X_subset, y_subset): ...
    def predict(self, X) -> None: ...

class MockClassifier:
    a: Any
    allow_nd: Any
    def __init__(self, a: int = ..., allow_nd: bool = ...) -> None: ...
    dummy_int: Any
    dummy_str: Any
    dummy_obj: Any
    def fit(self, X, Y: Any | None = ..., sample_weight: Any | None = ..., class_prior: Any | None = ..., sparse_sample_weight: Any | None = ..., sparse_param: Any | None = ..., dummy_int: Any | None = ..., dummy_str: Any | None = ..., dummy_obj: Any | None = ..., callback: Any | None = ...): ...
    def predict(self, T): ...
    def predict_proba(self, T): ...
    def score(self, X: Any | None = ..., Y: Any | None = ...): ...
    def get_params(self, deep: bool = ...): ...

X: Any
X_sparse: Any
y: Any
y2: Any
P_sparse: Any

def test_cross_val_score(): ...
def test_cross_validate_many_jobs() -> None: ...
def test_cross_validate_invalid_scoring_param() -> None: ...
def test_cross_validate_nested_estimator() -> None: ...
def test_cross_validate() -> None: ...
def check_cross_validate_single_metric(clf, X, y, scores) -> None: ...
def check_cross_validate_multi_metric(clf, X, y, scores): ...
def test_cross_val_score_predict_groups() -> None: ...
def test_cross_val_score_pandas(): ...
def test_cross_val_score_mask() -> None: ...
def test_cross_val_score_precomputed(): ...
def test_cross_val_score_fit_params() -> None: ...
def test_cross_val_score_score_func(): ...
def test_cross_val_score_errors() -> None: ...
def test_cross_val_score_with_score_func_classification() -> None: ...
def test_cross_val_score_with_score_func_regression() -> None: ...
def test_permutation_score(): ...
def test_permutation_test_score_allow_nans() -> None: ...
def test_permutation_test_score_fit_params() -> None: ...
def test_cross_val_score_allow_nans() -> None: ...
def test_cross_val_score_multilabel() -> None: ...
def test_cross_val_predict() -> None: ...
def test_cross_val_predict_decision_function_shape() -> None: ...
def test_cross_val_predict_predict_proba_shape() -> None: ...
def test_cross_val_predict_predict_log_proba_shape() -> None: ...
def test_cross_val_predict_input_types(): ...
def test_cross_val_predict_pandas(): ...
def test_cross_val_predict_unbalanced() -> None: ...
def test_cross_val_predict_y_none() -> None: ...
def test_cross_val_score_sparse_fit_params() -> None: ...
def test_learning_curve() -> None: ...
def test_learning_curve_unsupervised() -> None: ...
def test_learning_curve_verbose() -> None: ...
def test_learning_curve_incremental_learning_not_possible() -> None: ...
def test_learning_curve_incremental_learning() -> None: ...
def test_learning_curve_incremental_learning_unsupervised() -> None: ...
def test_learning_curve_batch_and_incremental_learning_are_equal() -> None: ...
def test_learning_curve_n_sample_range_out_of_bounds() -> None: ...
def test_learning_curve_remove_duplicate_sample_sizes() -> None: ...
def test_learning_curve_with_boolean_indices() -> None: ...
def test_learning_curve_with_shuffle() -> None: ...
def test_learning_curve_fit_params() -> None: ...
def test_learning_curve_incremental_learning_fit_params() -> None: ...
def test_validation_curve() -> None: ...
def test_validation_curve_clone_estimator() -> None: ...
def test_validation_curve_cv_splits_consistency() -> None: ...
def test_validation_curve_fit_params() -> None: ...
def test_check_is_permutation() -> None: ...
def test_cross_val_predict_sparse_prediction() -> None: ...
def check_cross_val_predict_binary(est, X, y, method) -> None: ...
def check_cross_val_predict_multiclass(est, X, y, method) -> None: ...
def check_cross_val_predict_multilabel(est, X, y, method) -> None: ...
def check_cross_val_predict_with_method_binary(est) -> None: ...
def check_cross_val_predict_with_method_multiclass(est) -> None: ...
def test_cross_val_predict_with_method() -> None: ...
def test_cross_val_predict_method_checking() -> None: ...
def test_gridsearchcv_cross_val_predict_with_method() -> None: ...
def test_cross_val_predict_with_method_multilabel_ovr() -> None: ...

class RFWithDecisionFunction(RandomForestClassifier):
    def decision_function(self, X): ...

def test_cross_val_predict_with_method_multilabel_rf() -> None: ...
def test_cross_val_predict_with_method_rare_class() -> None: ...
def test_cross_val_predict_with_method_multilabel_rf_rare_class() -> None: ...
def get_expected_predictions(X, y, cv, classes, est, method): ...
def test_cross_val_predict_class_subset() -> None: ...
def test_score_memmap(): ...
def test_permutation_test_score_pandas(): ...
def test_fit_and_score_failing() -> None: ...
def test_fit_and_score_working() -> None: ...
def test_cross_validate_failing_fits_warnings(error_score) -> None: ...
def test_cross_val_score_failing_scorer(error_score) -> None: ...
def test_cross_validate_failing_scorer(error_score, return_train_score, with_multimetric) -> None: ...
def three_params_scorer(i, j, k): ...
def test_fit_and_score_verbosity(capsys, train_score, scorer, verbose, split_prg, cdt_prg, expected) -> None: ...
def test_score() -> None: ...
def test_callable_multimetric_confusion_matrix_cross_validate(): ...
def test_validation_pairwise(): ...
