from sklearn.compose import make_column_transformer as make_column_transformer
from sklearn.datasets import make_classification as make_classification
from sklearn.exceptions import NotFittedError as NotFittedError
from sklearn.linear_model import LogisticRegression as LogisticRegression
from sklearn.metrics import ConfusionMatrixDisplay as ConfusionMatrixDisplay, confusion_matrix as confusion_matrix, plot_confusion_matrix as plot_confusion_matrix
from sklearn.pipeline import make_pipeline as make_pipeline
from sklearn.preprocessing import StandardScaler as StandardScaler
from sklearn.svm import SVC as SVC, SVR as SVR
from typing import Any

pytestmark: Any

def n_classes(): ...
def data(n_classes): ...
def fitted_clf(data): ...
def y_pred(data, fitted_clf): ...
def test_error_on_regressor(pyplot, data) -> None: ...
def test_error_on_invalid_option(pyplot, fitted_clf, data) -> None: ...
def test_plot_confusion_matrix_custom_labels(pyplot, data, y_pred, fitted_clf, n_classes, with_labels, with_display_labels) -> None: ...
def test_plot_confusion_matrix(pyplot, data, y_pred, n_classes, fitted_clf, normalize, include_values) -> None: ...
def test_confusion_matrix_display(pyplot, data, fitted_clf, y_pred, n_classes) -> None: ...
def test_confusion_matrix_contrast(pyplot) -> None: ...
def test_confusion_matrix_pipeline(pyplot, clf, data, n_classes) -> None: ...
def test_plot_confusion_matrix_colorbar(pyplot, data, fitted_clf, colorbar) -> None: ...
def test_confusion_matrix_text_format(pyplot, data, y_pred, n_classes, fitted_clf, values_format) -> None: ...
def test_confusion_matrix_standard_format(pyplot) -> None: ...
def test_default_labels(pyplot, display_labels, expected_labels) -> None: ...
def test_error_on_a_dataset_with_unseen_labels(pyplot, fitted_clf, data, n_classes) -> None: ...
def test_plot_confusion_matrix_deprecation_warning(pyplot, fitted_clf, data) -> None: ...
