from sklearn import datasets as datasets, linear_model as linear_model, metrics as metrics
from sklearn.base import clone as clone, is_classifier as is_classifier
from sklearn.exceptions import ConvergenceWarning as ConvergenceWarning
from sklearn.kernel_approximation import Nystroem as Nystroem
from sklearn.model_selection import RandomizedSearchCV as RandomizedSearchCV, ShuffleSplit as ShuffleSplit, StratifiedShuffleSplit as StratifiedShuffleSplit
from sklearn.pipeline import make_pipeline as make_pipeline
from sklearn.preprocessing import LabelEncoder as LabelEncoder, MinMaxScaler as MinMaxScaler, StandardScaler as StandardScaler, scale as scale
from sklearn.svm import OneClassSVM as OneClassSVM
from sklearn.utils._testing import assert_allclose as assert_allclose, assert_almost_equal as assert_almost_equal, assert_array_almost_equal as assert_array_almost_equal, assert_array_equal as assert_array_equal, ignore_warnings as ignore_warnings
from sklearn.utils.fixes import parse_version as parse_version
from typing import Any

class _SparseSGDClassifier(linear_model.SGDClassifier):
    def fit(self, X, y, *args, **kw): ...
    def partial_fit(self, X, y, *args, **kw): ...
    def decision_function(self, X): ...
    def predict_proba(self, X): ...

class _SparseSGDRegressor(linear_model.SGDRegressor):
    def fit(self, X, y, *args, **kw): ...
    def partial_fit(self, X, y, *args, **kw): ...
    def decision_function(self, X, *args, **kw): ...

class _SparseSGDOneClassSVM(linear_model.SGDOneClassSVM):
    def fit(self, X, *args, **kw): ...
    def partial_fit(self, X, *args, **kw): ...
    def decision_function(self, X, *args, **kw): ...

def SGDClassifier(**kwargs): ...
def SGDRegressor(**kwargs): ...
def SGDOneClassSVM(**kwargs): ...
def SparseSGDClassifier(**kwargs): ...
def SparseSGDRegressor(**kwargs): ...
def SparseSGDOneClassSVM(**kwargs): ...

X: Any
Y: Any
T: Any
true_result: Any
X2: Any
Y2: Any
T2: Any
true_result2: Any
X3: Any
Y3: Any
X4: Any
Y4: Any
iris: Any
X5: Any
Y5: Any
true_result5: Any

def asgd(klass, X, y, eta, alpha, weight_init: Any | None = ..., intercept_init: float = ...): ...
def test_sgd_estimator_params_validation(klass, fit_method, params, err_msg) -> None: ...
def test_warm_start(klass, lr) -> None: ...
def test_input_format(klass) -> None: ...
def test_clone(klass) -> None: ...
def test_plain_has_no_average_attr(klass) -> None: ...
def test_late_onset_averaging_not_reached(klass) -> None: ...
def test_late_onset_averaging_reached(klass) -> None: ...
def test_early_stopping(klass) -> None: ...
def test_adaptive_longer_than_constant(klass) -> None: ...
def test_validation_set_not_used_for_training(klass) -> None: ...
def test_n_iter_no_change(klass) -> None: ...
def test_not_enough_sample_for_early_stopping(klass) -> None: ...
def test_sgd_clf(klass) -> None: ...
def test_provide_coef(klass) -> None: ...
def test_set_intercept_offset(klass, fit_params) -> None: ...
def test_sgd_early_stopping_with_partial_fit(klass) -> None: ...
def test_set_intercept_offset_binary(klass, fit_params) -> None: ...
def test_average_binary_computed_correctly(klass) -> None: ...
def test_set_intercept_to_intercept(klass) -> None: ...
def test_sgd_at_least_two_labels(klass) -> None: ...
def test_partial_fit_weight_class_balanced(klass) -> None: ...
def test_sgd_multiclass(klass) -> None: ...
def test_sgd_multiclass_average(klass) -> None: ...
def test_sgd_multiclass_with_init_coef(klass) -> None: ...
def test_sgd_multiclass_njobs(klass) -> None: ...
def test_set_coef_multiclass(klass) -> None: ...
def test_sgd_predict_proba_method_access(klass) -> None: ...
def test_sgd_proba(klass) -> None: ...
def test_sgd_l1(klass) -> None: ...
def test_class_weights(klass) -> None: ...
def test_equal_class_weight(klass) -> None: ...
def test_wrong_class_weight_label(klass) -> None: ...
def test_wrong_class_weight_format(klass) -> None: ...
def test_weights_multiplied(klass) -> None: ...
def test_balanced_weight(klass) -> None: ...
def test_sample_weights(klass) -> None: ...
def test_wrong_sample_weights(klass) -> None: ...
def test_partial_fit_exception(klass) -> None: ...
def test_partial_fit_binary(klass) -> None: ...
def test_partial_fit_multiclass(klass) -> None: ...
def test_partial_fit_multiclass_average(klass) -> None: ...
def test_fit_then_partial_fit(klass) -> None: ...
def test_partial_fit_equal_fit_classif(klass, lr) -> None: ...
def test_regression_losses(klass) -> None: ...
def test_warm_start_multiclass(klass) -> None: ...
def test_multiple_fit(klass) -> None: ...
def test_sgd_reg(klass) -> None: ...
def test_sgd_averaged_computed_correctly(klass) -> None: ...
def test_sgd_averaged_partial_fit(klass) -> None: ...
def test_average_sparse(klass) -> None: ...
def test_sgd_least_squares_fit(klass) -> None: ...
def test_sgd_epsilon_insensitive(klass) -> None: ...
def test_sgd_huber_fit(klass) -> None: ...
def test_elasticnet_convergence(klass) -> None: ...
def test_partial_fit(klass) -> None: ...
def test_partial_fit_equal_fit(klass, lr) -> None: ...
def test_loss_function_epsilon(klass) -> None: ...
def asgd_oneclass(klass, X, eta, nu, coef_init: Any | None = ..., offset_init: float = ...): ...
def test_warm_start_oneclass(klass, lr) -> None: ...
def test_clone_oneclass(klass) -> None: ...
def test_partial_fit_oneclass(klass) -> None: ...
def test_partial_fit_equal_fit_oneclass(klass, lr) -> None: ...
def test_late_onset_averaging_reached_oneclass(klass) -> None: ...
def test_sgd_averaged_computed_correctly_oneclass(klass) -> None: ...
def test_sgd_averaged_partial_fit_oneclass(klass) -> None: ...
def test_average_sparse_oneclass(klass) -> None: ...
def test_sgd_oneclass() -> None: ...
def test_ocsvm_vs_sgdocsvm() -> None: ...
def test_l1_ratio() -> None: ...
def test_underflow_or_overlow() -> None: ...
def test_numerical_stability_large_gradient() -> None: ...
def test_large_regularization(penalty) -> None: ...
def test_tol_parameter() -> None: ...
def test_loss_hinge() -> None: ...
def test_gradient_squared_hinge() -> None: ...
def test_loss_log() -> None: ...
def test_loss_squared_loss() -> None: ...
def test_loss_huber() -> None: ...
def test_loss_modified_huber() -> None: ...
def test_loss_epsilon_insensitive() -> None: ...
def test_loss_squared_epsilon_insensitive() -> None: ...
def test_multi_thread_multi_class_and_early_stopping() -> None: ...
def test_multi_core_gridsearch_and_early_stopping() -> None: ...
def test_SGDClassifier_fit_for_all_backends(backend) -> None: ...
def test_loss_squared_loss_deprecated(Estimator) -> None: ...
