from sklearn.base import BaseEstimator as BaseEstimator, ClassifierMixin as ClassifierMixin, clone as clone
from sklearn.cluster import KMeans as KMeans
from sklearn.compose import make_column_transformer as make_column_transformer
from sklearn.datasets import load_iris as load_iris, make_classification as make_classification, make_regression as make_regression
from sklearn.dummy import DummyClassifier as DummyClassifier
from sklearn.ensemble import GradientBoostingClassifier as GradientBoostingClassifier, GradientBoostingRegressor as GradientBoostingRegressor, HistGradientBoostingClassifier as HistGradientBoostingClassifier, HistGradientBoostingRegressor as HistGradientBoostingRegressor, RandomForestRegressor as RandomForestRegressor
from sklearn.exceptions import NotFittedError as NotFittedError
from sklearn.inspection import partial_dependence as partial_dependence
from sklearn.linear_model import LinearRegression as LinearRegression, LogisticRegression as LogisticRegression, MultiTaskLasso as MultiTaskLasso
from sklearn.metrics import r2_score as r2_score
from sklearn.pipeline import make_pipeline as make_pipeline
from sklearn.preprocessing import PolynomialFeatures as PolynomialFeatures, RobustScaler as RobustScaler, StandardScaler as StandardScaler, scale as scale
from sklearn.tree import DecisionTreeRegressor as DecisionTreeRegressor
from sklearn.tree.tests.test_tree import assert_is_subtree as assert_is_subtree
from sklearn.utils._testing import assert_allclose as assert_allclose, assert_array_equal as assert_array_equal
from sklearn.utils.validation import check_random_state as check_random_state
from typing import Any

X: Any
y: Any
binary_classification_data: Any
multiclass_classification_data: Any
regression_data: Any
multioutput_regression_data: Any
iris: Any

def test_output_shape(Estimator, method, data, grid_resolution, features, kind) -> None: ...
def test_grid_from_X() -> None: ...
def test_grid_from_X_error(grid_resolution, percentiles, err_msg) -> None: ...
def test_partial_dependence_helpers(est, method, target_feature) -> None: ...
def test_recursion_decision_tree_vs_forest_and_gbdt(seed) -> None: ...
def test_recursion_decision_function(est, target_feature) -> None: ...
def test_partial_dependence_easy_target(est, power) -> None: ...
def test_multiclass_multioutput(Estimator) -> None: ...

class NoPredictProbaNoDecisionFunction(ClassifierMixin, BaseEstimator):
    classes_: Any
    def fit(self, X, y): ...

def test_partial_dependence_error(estimator, params, err_msg) -> None: ...
def test_partial_dependence_slice_error(with_dataframe, err_msg) -> None: ...
def test_partial_dependence_unknown_feature_indices(estimator, features) -> None: ...
def test_partial_dependence_unknown_feature_string(estimator) -> None: ...
def test_partial_dependence_X_list(estimator) -> None: ...
def test_warning_recursion_non_constant_init() -> None: ...
def test_partial_dependence_sample_weight() -> None: ...
def test_hist_gbdt_sw_not_supported() -> None: ...
def test_partial_dependence_pipeline() -> None: ...
def test_partial_dependence_dataframe(estimator, preprocessor, features) -> None: ...
def test_partial_dependence_feature_type(features, expected_pd_shape) -> None: ...
def test_partial_dependence_unfitted(estimator) -> None: ...
def test_kind_average_and_average_of_individual(Estimator, data) -> None: ...
def test_warning_for_kind_legacy() -> None: ...
