import abc
from ..base import clone as clone
from ..exceptions import ConvergenceWarning as ConvergenceWarning
from ..metrics.pairwise import pairwise_kernels as pairwise_kernels
from abc import ABCMeta, abstractmethod
from typing import Any

class Hyperparameter:
    def __new__(cls, name, value_type, bounds, n_elements: int = ..., fixed: Any | None = ...): ...
    def __eq__(self, other): ...

class Kernel(metaclass=ABCMeta):
    def get_params(self, deep: bool = ...): ...
    def set_params(self, **params): ...
    def clone_with_theta(self, theta): ...
    @property
    def n_dims(self): ...
    @property
    def hyperparameters(self): ...
    @property
    def theta(self): ...
    @theta.setter
    def theta(self, theta) -> None: ...
    @property
    def bounds(self): ...
    def __add__(self, b): ...
    def __radd__(self, b): ...
    def __mul__(self, b): ...
    def __rmul__(self, b): ...
    def __pow__(self, b): ...
    def __eq__(self, b): ...
    @abstractmethod
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...
    @abstractmethod
    def diag(self, X): ...
    @abstractmethod
    def is_stationary(self): ...
    @property
    def requires_vector_input(self): ...

class NormalizedKernelMixin:
    def diag(self, X): ...

class StationaryKernelMixin:
    def is_stationary(self): ...

class GenericKernelMixin:
    @property
    def requires_vector_input(self): ...

class CompoundKernel(Kernel):
    kernels: Any
    def __init__(self, kernels) -> None: ...
    def get_params(self, deep: bool = ...): ...
    @property
    def theta(self): ...
    @theta.setter
    def theta(self, theta) -> None: ...
    @property
    def bounds(self): ...
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...
    def __eq__(self, b): ...
    def is_stationary(self): ...
    @property
    def requires_vector_input(self): ...
    def diag(self, X): ...

class KernelOperator(Kernel, metaclass=abc.ABCMeta):
    k1: Any
    k2: Any
    def __init__(self, k1, k2) -> None: ...
    def get_params(self, deep: bool = ...): ...
    @property
    def hyperparameters(self): ...
    @property
    def theta(self): ...
    @theta.setter
    def theta(self, theta) -> None: ...
    @property
    def bounds(self): ...
    def __eq__(self, b): ...
    def is_stationary(self): ...
    @property
    def requires_vector_input(self): ...

class Sum(KernelOperator):
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...
    def diag(self, X): ...

class Product(KernelOperator):
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...
    def diag(self, X): ...

class Exponentiation(Kernel):
    kernel: Any
    exponent: Any
    def __init__(self, kernel, exponent) -> None: ...
    def get_params(self, deep: bool = ...): ...
    @property
    def hyperparameters(self): ...
    @property
    def theta(self): ...
    @theta.setter
    def theta(self, theta) -> None: ...
    @property
    def bounds(self): ...
    def __eq__(self, b): ...
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...
    def diag(self, X): ...
    def is_stationary(self): ...
    @property
    def requires_vector_input(self): ...

class ConstantKernel(StationaryKernelMixin, GenericKernelMixin, Kernel):
    constant_value: Any
    constant_value_bounds: Any
    def __init__(self, constant_value: float = ..., constant_value_bounds=...) -> None: ...
    @property
    def hyperparameter_constant_value(self): ...
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...
    def diag(self, X): ...

class WhiteKernel(StationaryKernelMixin, GenericKernelMixin, Kernel):
    noise_level: Any
    noise_level_bounds: Any
    def __init__(self, noise_level: float = ..., noise_level_bounds=...) -> None: ...
    @property
    def hyperparameter_noise_level(self): ...
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...
    def diag(self, X): ...

class RBF(StationaryKernelMixin, NormalizedKernelMixin, Kernel):
    length_scale: Any
    length_scale_bounds: Any
    def __init__(self, length_scale: float = ..., length_scale_bounds=...) -> None: ...
    @property
    def anisotropic(self): ...
    @property
    def hyperparameter_length_scale(self): ...
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...

class Matern(RBF):
    nu: Any
    def __init__(self, length_scale: float = ..., length_scale_bounds=..., nu: float = ...) -> None: ...
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...

class RationalQuadratic(StationaryKernelMixin, NormalizedKernelMixin, Kernel):
    length_scale: Any
    alpha: Any
    length_scale_bounds: Any
    alpha_bounds: Any
    def __init__(self, length_scale: float = ..., alpha: float = ..., length_scale_bounds=..., alpha_bounds=...) -> None: ...
    @property
    def hyperparameter_length_scale(self): ...
    @property
    def hyperparameter_alpha(self): ...
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...

class ExpSineSquared(StationaryKernelMixin, NormalizedKernelMixin, Kernel):
    length_scale: Any
    periodicity: Any
    length_scale_bounds: Any
    periodicity_bounds: Any
    def __init__(self, length_scale: float = ..., periodicity: float = ..., length_scale_bounds=..., periodicity_bounds=...) -> None: ...
    @property
    def hyperparameter_length_scale(self): ...
    @property
    def hyperparameter_periodicity(self): ...
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...

class DotProduct(Kernel):
    sigma_0: Any
    sigma_0_bounds: Any
    def __init__(self, sigma_0: float = ..., sigma_0_bounds=...) -> None: ...
    @property
    def hyperparameter_sigma_0(self): ...
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...
    def diag(self, X): ...
    def is_stationary(self): ...

class PairwiseKernel(Kernel):
    gamma: Any
    gamma_bounds: Any
    metric: Any
    pairwise_kernels_kwargs: Any
    def __init__(self, gamma: float = ..., gamma_bounds=..., metric: str = ..., pairwise_kernels_kwargs: Any | None = ...) -> None: ...
    @property
    def hyperparameter_gamma(self): ...
    def __call__(self, X, Y: Any | None = ..., eval_gradient: bool = ...): ...
    def diag(self, X): ...
    def is_stationary(self): ...
