from sklearn import datasets as datasets
from sklearn.base import BaseEstimator as BaseEstimator
from sklearn.decomposition import PCA as PCA
from sklearn.ensemble import HistGradientBoostingClassifier as HistGradientBoostingClassifier, RandomForestClassifier as RandomForestClassifier
from sklearn.feature_selection import SelectFromModel as SelectFromModel
from sklearn.linear_model import Lasso as Lasso, LogisticRegression as LogisticRegression, PassiveAggressiveClassifier as PassiveAggressiveClassifier, SGDClassifier as SGDClassifier
from sklearn.pipeline import make_pipeline as make_pipeline
from sklearn.svm import LinearSVC as LinearSVC
from sklearn.utils._testing import MinimalClassifier as MinimalClassifier, assert_allclose as assert_allclose, assert_array_almost_equal as assert_array_almost_equal, assert_array_equal as assert_array_equal, skip_if_32bit as skip_if_32bit
from typing import Any

class NaNTag(BaseEstimator): ...
class NoNaNTag(BaseEstimator): ...
class NaNTagRandomForest(RandomForestClassifier): ...

iris: Any
data: Any
y: Any
rng: Any

def test_invalid_input() -> None: ...
def test_input_estimator_unchanged() -> None: ...
def test_max_features_error(max_features, err_type, err_msg) -> None: ...
def test_max_features_dim(max_features) -> None: ...

class FixedImportanceEstimator(BaseEstimator):
    importances: Any
    def __init__(self, importances) -> None: ...
    feature_importances_: Any
    def fit(self, X, y: Any | None = ...) -> None: ...

def test_max_features() -> None: ...
def test_max_features_tiebreak() -> None: ...
def test_threshold_and_max_features() -> None: ...
def test_feature_importances() -> None: ...
def test_sample_weight() -> None: ...
def test_coef_default_threshold() -> None: ...
def test_2d_coef() -> None: ...
def test_partial_fit() -> None: ...
def test_calling_fit_reinitializes() -> None: ...
def test_prefit() -> None: ...
def test_threshold_string() -> None: ...
def test_threshold_without_refitting() -> None: ...
def test_fit_accepts_nan_inf() -> None: ...
def test_transform_accepts_nan_inf() -> None: ...
def test_allow_nan_tag_comes_from_estimator() -> None: ...
def test_importance_getter(estimator, importance_getter) -> None: ...
def test_estimator_does_not_support_feature_names(): ...
