from sklearn.base import BaseEstimator as BaseEstimator, ClassifierMixin as ClassifierMixin, RegressorMixin as RegressorMixin, clone as clone
from sklearn.datasets import load_breast_cancer as load_breast_cancer, load_diabetes as load_diabetes, load_iris as load_iris, make_classification as make_classification, make_regression as make_regression
from sklearn.dummy import DummyClassifier as DummyClassifier, DummyRegressor as DummyRegressor
from sklearn.ensemble import RandomForestClassifier as RandomForestClassifier, RandomForestRegressor as RandomForestRegressor, StackingClassifier as StackingClassifier, StackingRegressor as StackingRegressor
from sklearn.exceptions import ConvergenceWarning as ConvergenceWarning
from sklearn.linear_model import LinearRegression as LinearRegression, LogisticRegression as LogisticRegression
from sklearn.model_selection import KFold as KFold, StratifiedKFold as StratifiedKFold, train_test_split as train_test_split
from sklearn.preprocessing import scale as scale
from sklearn.svm import LinearSVC as LinearSVC, LinearSVR as LinearSVR, SVC as SVC
from sklearn.utils._mocking import CheckingClassifier as CheckingClassifier
from sklearn.utils._testing import assert_allclose as assert_allclose, assert_allclose_dense_sparse as assert_allclose_dense_sparse, ignore_warnings as ignore_warnings
from typing import Any

X_diabetes: Any
y_diabetes: Any
X_iris: Any
y_iris: Any

def test_stacking_classifier_iris(cv, final_estimator, passthrough) -> None: ...
def test_stacking_classifier_drop_column_binary_classification() -> None: ...
def test_stacking_classifier_drop_estimator() -> None: ...
def test_stacking_regressor_drop_estimator() -> None: ...
def test_stacking_regressor_diabetes(cv, final_estimator, predict_params, passthrough) -> None: ...
def test_stacking_regressor_sparse_passthrough(fmt) -> None: ...
def test_stacking_classifier_sparse_passthrough(fmt) -> None: ...
def test_stacking_classifier_drop_binary_prob() -> None: ...

class NoWeightRegressor(RegressorMixin, BaseEstimator):
    reg: Any
    def fit(self, X, y): ...
    def predict(self, X): ...

class NoWeightClassifier(ClassifierMixin, BaseEstimator):
    clf: Any
    def fit(self, X, y): ...

def test_stacking_classifier_error(y, params, type_err, msg_err) -> None: ...
def test_stacking_regressor_error(y, params, type_err, msg_err) -> None: ...
def test_stacking_randomness(estimator, X, y) -> None: ...
def test_stacking_classifier_stratify_default() -> None: ...
def test_stacking_with_sample_weight(stacker, X, y) -> None: ...
def test_stacking_classifier_sample_weight_fit_param() -> None: ...
def test_stacking_cv_influence(stacker, X, y) -> None: ...
def test_stacking_without_n_features_in(make_dataset, Stacking, Estimator) -> None: ...
