from sklearn.base import BaseEstimator as BaseEstimator
from sklearn.datasets import load_diabetes as load_diabetes, load_iris as load_iris, make_hastie_10_2 as make_hastie_10_2
from sklearn.dummy import DummyClassifier as DummyClassifier, DummyRegressor as DummyRegressor
from sklearn.ensemble import BaggingClassifier as BaggingClassifier, BaggingRegressor as BaggingRegressor
from sklearn.feature_selection import SelectKBest as SelectKBest
from sklearn.linear_model import LogisticRegression as LogisticRegression, Perceptron as Perceptron
from sklearn.model_selection import GridSearchCV as GridSearchCV, ParameterGrid as ParameterGrid, train_test_split as train_test_split
from sklearn.neighbors import KNeighborsClassifier as KNeighborsClassifier, KNeighborsRegressor as KNeighborsRegressor
from sklearn.pipeline import make_pipeline as make_pipeline
from sklearn.preprocessing import FunctionTransformer as FunctionTransformer, scale as scale
from sklearn.random_projection import SparseRandomProjection as SparseRandomProjection
from sklearn.svm import SVC as SVC, SVR as SVR
from sklearn.tree import DecisionTreeClassifier as DecisionTreeClassifier, DecisionTreeRegressor as DecisionTreeRegressor
from sklearn.utils import check_random_state as check_random_state
from sklearn.utils._testing import assert_array_almost_equal as assert_array_almost_equal, assert_array_equal as assert_array_equal
from typing import Any

rng: Any
iris: Any
perm: Any
diabetes: Any

def test_classification() -> None: ...
def test_sparse_classification(sparse_format, params, method): ...
def test_regression() -> None: ...
def test_sparse_regression(): ...

class DummySizeEstimator(BaseEstimator):
    training_size_: Any
    training_hash_: Any
    def fit(self, X, y) -> None: ...

def test_bootstrap_samples() -> None: ...
def test_bootstrap_features() -> None: ...
def test_probability() -> None: ...
def test_oob_score_classification() -> None: ...
def test_oob_score_regression() -> None: ...
def test_single_estimator() -> None: ...
def test_error() -> None: ...
def test_parallel_classification() -> None: ...
def test_parallel_regression() -> None: ...
def test_gridsearch() -> None: ...
def test_base_estimator() -> None: ...
def test_bagging_with_pipeline() -> None: ...

class DummyZeroEstimator(BaseEstimator):
    classes_: Any
    def fit(self, X, y): ...
    def predict(self, X): ...

def test_bagging_sample_weight_unsupported_but_passed() -> None: ...
def test_warm_start(random_state: int = ...) -> None: ...
def test_warm_start_smaller_n_estimators() -> None: ...
def test_warm_start_equal_n_estimators() -> None: ...
def test_warm_start_equivalence() -> None: ...
def test_warm_start_with_oob_score_fails() -> None: ...
def test_oob_score_removed_on_warm_start() -> None: ...
def test_oob_score_consistency() -> None: ...
def test_estimators_samples() -> None: ...
def test_estimators_samples_deterministic() -> None: ...
def test_max_samples_consistency() -> None: ...
def test_set_oob_score_label_encoding() -> None: ...
def replace(X): ...
def test_bagging_regressor_with_missing_inputs() -> None: ...
def test_bagging_classifier_with_missing_inputs() -> None: ...
def test_bagging_small_max_features() -> None: ...
def test_bagging_get_estimators_indices() -> None: ...
def test_n_features_deprecation(Estimator) -> None: ...
