import abc
from .common import G_H_DTYPE as G_H_DTYPE, Y_DTYPE as Y_DTYPE
from abc import ABC, abstractmethod
from typing import Any

class BaseLoss(ABC, metaclass=abc.ABCMeta):
    hessians_are_constant: Any
    n_threads: Any
    def __init__(self, hessians_are_constant, n_threads: Any | None = ...) -> None: ...
    def __call__(self, y_true, raw_predictions, sample_weight): ...
    @abstractmethod
    def pointwise_loss(self, y_true, raw_predictions): ...
    need_update_leaves_values: bool
    def init_gradients_and_hessians(self, n_samples, prediction_dim, sample_weight): ...
    @abstractmethod
    def get_baseline_prediction(self, y_train, sample_weight, prediction_dim): ...
    @abstractmethod
    def update_gradients_and_hessians(self, gradients, hessians, y_true, raw_predictions, sample_weight): ...

class LeastSquares(BaseLoss):
    def __init__(self, sample_weight, n_threads: Any | None = ...) -> None: ...
    def pointwise_loss(self, y_true, raw_predictions): ...
    def get_baseline_prediction(self, y_train, sample_weight, prediction_dim): ...
    @staticmethod
    def inverse_link_function(raw_predictions): ...
    def update_gradients_and_hessians(self, gradients, hessians, y_true, raw_predictions, sample_weight) -> None: ...

class LeastAbsoluteDeviation(BaseLoss):
    def __init__(self, sample_weight, n_threads: Any | None = ...) -> None: ...
    need_update_leaves_values: bool
    def pointwise_loss(self, y_true, raw_predictions): ...
    def get_baseline_prediction(self, y_train, sample_weight, prediction_dim): ...
    @staticmethod
    def inverse_link_function(raw_predictions): ...
    def update_gradients_and_hessians(self, gradients, hessians, y_true, raw_predictions, sample_weight) -> None: ...
    def update_leaves_values(self, grower, y_true, raw_predictions, sample_weight) -> None: ...

class Poisson(BaseLoss):
    def __init__(self, sample_weight, n_threads: Any | None = ...) -> None: ...
    inverse_link_function: Any
    def pointwise_loss(self, y_true, raw_predictions): ...
    def get_baseline_prediction(self, y_train, sample_weight, prediction_dim): ...
    def update_gradients_and_hessians(self, gradients, hessians, y_true, raw_predictions, sample_weight) -> None: ...

class BinaryCrossEntropy(BaseLoss):
    def __init__(self, sample_weight, n_threads: Any | None = ...) -> None: ...
    inverse_link_function: Any
    def pointwise_loss(self, y_true, raw_predictions): ...
    def get_baseline_prediction(self, y_train, sample_weight, prediction_dim): ...
    def update_gradients_and_hessians(self, gradients, hessians, y_true, raw_predictions, sample_weight) -> None: ...
    def predict_proba(self, raw_predictions): ...

class CategoricalCrossEntropy(BaseLoss):
    def __init__(self, sample_weight, n_threads: Any | None = ...) -> None: ...
    def pointwise_loss(self, y_true, raw_predictions): ...
    def get_baseline_prediction(self, y_train, sample_weight, prediction_dim): ...
    def update_gradients_and_hessians(self, gradients, hessians, y_true, raw_predictions, sample_weight) -> None: ...
    def predict_proba(self, raw_predictions): ...
