from ..dummy import DummyClassifier as DummyClassifier, DummyRegressor as DummyRegressor
from ..tree._tree import TREE_LEAF as TREE_LEAF
from abc import ABCMeta, abstractmethod
from typing import Any

class LossFunction(metaclass=ABCMeta):
    is_multi_class: bool
    K: Any
    def __init__(self, n_classes) -> None: ...
    def init_estimator(self) -> None: ...
    @abstractmethod
    def __call__(self, y, raw_predictions, sample_weight: Any | None = ...): ...
    @abstractmethod
    def negative_gradient(self, y, raw_predictions, **kargs): ...
    def update_terminal_regions(self, tree, X, y, residual, raw_predictions, sample_weight, sample_mask, learning_rate: float = ..., k: int = ...) -> None: ...
    @abstractmethod
    def get_init_raw_predictions(self, X, estimator): ...

class RegressionLossFunction(LossFunction, metaclass=ABCMeta):
    def __init__(self) -> None: ...
    def check_init_estimator(self, estimator) -> None: ...
    def get_init_raw_predictions(self, X, estimator): ...

class LeastSquaresError(RegressionLossFunction):
    def init_estimator(self): ...
    def __call__(self, y, raw_predictions, sample_weight: Any | None = ...): ...
    def negative_gradient(self, y, raw_predictions, **kargs): ...
    def update_terminal_regions(self, tree, X, y, residual, raw_predictions, sample_weight, sample_mask, learning_rate: float = ..., k: int = ...) -> None: ...

class LeastAbsoluteError(RegressionLossFunction):
    def init_estimator(self): ...
    def __call__(self, y, raw_predictions, sample_weight: Any | None = ...): ...
    def negative_gradient(self, y, raw_predictions, **kargs): ...

class HuberLossFunction(RegressionLossFunction):
    alpha: Any
    gamma: Any
    def __init__(self, alpha: float = ...) -> None: ...
    def init_estimator(self): ...
    def __call__(self, y, raw_predictions, sample_weight: Any | None = ...): ...
    def negative_gradient(self, y, raw_predictions, sample_weight: Any | None = ..., **kargs): ...

class QuantileLossFunction(RegressionLossFunction):
    alpha: Any
    percentile: Any
    def __init__(self, alpha: float = ...) -> None: ...
    def init_estimator(self): ...
    def __call__(self, y, raw_predictions, sample_weight: Any | None = ...): ...
    def negative_gradient(self, y, raw_predictions, **kargs): ...

class ClassificationLossFunction(LossFunction, metaclass=ABCMeta):
    def check_init_estimator(self, estimator) -> None: ...

class BinomialDeviance(ClassificationLossFunction):
    def __init__(self, n_classes) -> None: ...
    def init_estimator(self): ...
    def __call__(self, y, raw_predictions, sample_weight: Any | None = ...): ...
    def negative_gradient(self, y, raw_predictions, **kargs): ...
    def get_init_raw_predictions(self, X, estimator): ...

class MultinomialDeviance(ClassificationLossFunction):
    is_multi_class: bool
    def __init__(self, n_classes) -> None: ...
    def init_estimator(self): ...
    def __call__(self, y, raw_predictions, sample_weight: Any | None = ...): ...
    def negative_gradient(self, y, raw_predictions, k: int = ..., **kwargs): ...
    def get_init_raw_predictions(self, X, estimator): ...

class ExponentialLoss(ClassificationLossFunction):
    def __init__(self, n_classes) -> None: ...
    def init_estimator(self): ...
    def __call__(self, y, raw_predictions, sample_weight: Any | None = ...): ...
    def negative_gradient(self, y, raw_predictions, **kargs): ...
    def get_init_raw_predictions(self, X, estimator): ...

LOSS_FUNCTIONS: Any
