from sklearn.base import BaseEstimator as BaseEstimator
from sklearn.compose import ColumnTransformer as ColumnTransformer, make_column_selector as make_column_selector, make_column_transformer as make_column_transformer
from sklearn.exceptions import NotFittedError as NotFittedError
from sklearn.feature_extraction import DictVectorizer as DictVectorizer
from sklearn.preprocessing import FunctionTransformer as FunctionTransformer, Normalizer as Normalizer, OneHotEncoder as OneHotEncoder, StandardScaler as StandardScaler
from sklearn.utils._testing import assert_allclose_dense_sparse as assert_allclose_dense_sparse, assert_almost_equal as assert_almost_equal, assert_array_equal as assert_array_equal
from typing import Any

class Trans(BaseEstimator):
    def fit(self, X, y: Any | None = ...): ...
    def transform(self, X, y: Any | None = ...): ...

class DoubleTrans(BaseEstimator):
    def fit(self, X, y: Any | None = ...): ...
    def transform(self, X): ...

class SparseMatrixTrans(BaseEstimator):
    def fit(self, X, y: Any | None = ...): ...
    def transform(self, X, y: Any | None = ...): ...

class TransNo2D(BaseEstimator):
    def fit(self, X, y: Any | None = ...): ...
    def transform(self, X, y: Any | None = ...): ...

class TransRaise(BaseEstimator):
    def fit(self, X, y: Any | None = ...) -> None: ...
    def transform(self, X, y: Any | None = ...) -> None: ...

def test_column_transformer(): ...
def test_column_transformer_dataframe(): ...
def test_column_transformer_empty_columns(pandas, column_selection, callable_column): ...
def test_column_transformer_output_indices() -> None: ...
def test_column_transformer_output_indices_df() -> None: ...
def test_column_transformer_sparse_array() -> None: ...
def test_column_transformer_list() -> None: ...
def test_column_transformer_sparse_stacking() -> None: ...
def test_column_transformer_mixed_cols_sparse() -> None: ...
def test_column_transformer_sparse_threshold() -> None: ...
def test_column_transformer_error_msg_1D() -> None: ...
def test_2D_transformer_output() -> None: ...
def test_2D_transformer_output_pandas() -> None: ...
def test_column_transformer_invalid_columns(remainder) -> None: ...
def test_column_transformer_invalid_transformer(): ...
def test_make_column_transformer() -> None: ...
def test_make_column_transformer_pandas() -> None: ...
def test_make_column_transformer_kwargs() -> None: ...
def test_make_column_transformer_remainder_transformer() -> None: ...
def test_column_transformer_get_set_params() -> None: ...
def test_column_transformer_named_estimators() -> None: ...
def test_column_transformer_cloning() -> None: ...
def test_column_transformer_get_feature_names(get_names) -> None: ...
def test_column_transformer_get_feature_names_pipeline(X, keys): ...
def test_column_transformer_get_feature_names_dataframe(): ...
def test_column_transformer_special_strings() -> None: ...
def test_column_transformer_remainder() -> None: ...
def test_column_transformer_remainder_numpy(key) -> None: ...
def test_column_transformer_remainder_pandas(key) -> None: ...
def test_column_transformer_remainder_transformer(key) -> None: ...
def test_column_transformer_no_remaining_remainder_transformer() -> None: ...
def test_column_transformer_drops_all_remainder_transformer() -> None: ...
def test_column_transformer_sparse_remainder_transformer() -> None: ...
def test_column_transformer_drop_all_sparse_remainder_transformer() -> None: ...
def test_column_transformer_get_set_params_with_remainder() -> None: ...
def test_column_transformer_no_estimators() -> None: ...
def test_column_transformer_verbose(est, pattern, method, capsys) -> None: ...
def test_column_transformer_no_estimators_set_params() -> None: ...
def test_column_transformer_callable_specifier(): ...
def test_column_transformer_callable_specifier_dataframe(): ...
def test_column_transformer_negative_column_indexes() -> None: ...
def test_column_transformer_mask_indexing(array_type) -> None: ...
def test_n_features_in() -> None: ...
def test_make_column_selector_with_select_dtypes(cols, pattern, include, exclude) -> None: ...
def test_column_transformer_with_make_column_selector() -> None: ...
def test_make_column_selector_error() -> None: ...
def test_make_column_selector_pickle() -> None: ...
def test_feature_names_empty_columns(empty_col, get_names, expected_names) -> None: ...
def test_feature_names_out_pandas(selector) -> None: ...
def test_feature_names_out_non_pandas(selector) -> None: ...
def test_sk_visual_block_remainder(remainder) -> None: ...
def test_sk_visual_block_remainder_drop() -> None: ...
def test_sk_visual_block_remainder_fitted_pandas(remainder) -> None: ...
def test_sk_visual_block_remainder_fitted_numpy(remainder) -> None: ...
def test_column_transformers_get_feature_names_deprecated() -> None: ...
def test_column_transformer_reordered_column_names_remainder(explicit_colname, remainder) -> None: ...
def test_feature_name_validation_missing_columns_drop_passthough() -> None: ...
def test_get_feature_names_empty_selection(selector) -> None: ...
def test_feature_names_in_() -> None: ...

class TransWithNames(Trans):
    feature_names_out: Any
    def __init__(self, feature_names_out: Any | None = ...) -> None: ...
    def get_feature_names_out(self, input_features: Any | None = ...): ...

def test_verbose_feature_names_out_true(transformers, remainder, expected_names) -> None: ...
def test_verbose_feature_names_out_false(transformers, remainder, expected_names) -> None: ...
def test_verbose_feature_names_out_false_errors(transformers, remainder, colliding_columns) -> None: ...
