from ._config import get_config as get_config
from .utils._estimator_html_repr import estimator_html_repr as estimator_html_repr
from .utils.validation import check_X_y as check_X_y, check_array as check_array
from typing import Any
import numpy

def clone(estimator, *, safe: bool = ...): ...

class BaseEstimator:
    def get_params(self, deep: bool = ...): ...
    def set_params(self, **params): ...

class ClassifierMixin:
    def score(self, X, y, sample_weight: Any | None = ...): ...

class RegressorMixin:
    def score(self, X, y, sample_weight: Any | None = ...): ...

class ClusterMixin:
    def fit_predict(self, X, y: Any | None = ...): ...

class BiclusterMixin:
    @property
    def biclusters_(self): ...
    def get_indices(self, i): ...
    def get_shape(self, i): ...
    def get_submatrix(self, i, data): ...

class TransformerMixin:
    def fit_transform(self, X, y: Any | None = ..., **fit_params) -> numpy.ndarray: ...

class _OneToOneFeatureMixin:
    def get_feature_names_out(self, input_features: Any | None = ...): ...

class DensityMixin:
    def score(self, X, y: Any | None = ...) -> None: ...

class OutlierMixin:
    def fit_predict(self, X, y: Any | None = ...): ...

class MetaEstimatorMixin: ...
class MultiOutputMixin: ...
class _UnstableArchMixin: ...

def is_classifier(estimator): ...
def is_regressor(estimator): ...
def is_outlier_detector(estimator): ...
