from abc import ABCMeta, abstractmethod
from typing import Any, NamedTuple

class DistributionBoundary(NamedTuple):
    value: Any
    inclusive: Any

class ExponentialDispersionModel(metaclass=ABCMeta):
    def in_y_range(self, y): ...
    @abstractmethod
    def unit_variance(self, y_pred): ...
    @abstractmethod
    def unit_deviance(self, y, y_pred, check_input: bool = ...): ...
    def unit_deviance_derivative(self, y, y_pred): ...
    def deviance(self, y, y_pred, weights: int = ...): ...
    def deviance_derivative(self, y, y_pred, weights: int = ...): ...

class TweedieDistribution(ExponentialDispersionModel):
    def __init__(self, power: int = ...) -> None: ...
    @property
    def power(self): ...
    @power.setter
    def power(self, power) -> None: ...
    def unit_variance(self, y_pred): ...
    def unit_deviance(self, y, y_pred, check_input: bool = ...): ...

class NormalDistribution(TweedieDistribution):
    def __init__(self) -> None: ...

class PoissonDistribution(TweedieDistribution):
    def __init__(self) -> None: ...

class GammaDistribution(TweedieDistribution):
    def __init__(self) -> None: ...

class InverseGaussianDistribution(TweedieDistribution):
    def __init__(self) -> None: ...

EDM_DISTRIBUTIONS: Any
