from .._core import categorical_order as categorical_order
from .._statistics import Histogram as Histogram, KDE as KDE
from .._testing import assert_legends_equal as assert_legends_equal, assert_plots_equal as assert_plots_equal
from ..axisgrid import FacetGrid as FacetGrid
from ..distributions import displot as displot, distplot as distplot, ecdfplot as ecdfplot, histplot as histplot, kdeplot as kdeplot, rugplot as rugplot
from ..palettes import color_palette as color_palette, light_palette as light_palette
from typing import Any

class TestDistPlot:
    rs: Any
    x: Any
    def test_hist_bins(self) -> None: ...
    def test_elements(self) -> None: ...
    def test_distplot_with_nans(self) -> None: ...

class TestRugPlot:
    def assert_rug_equal(self, a, b) -> None: ...
    def test_long_data(self, long_df, variable) -> None: ...
    def test_bivariate_data(self, long_df) -> None: ...
    def test_wide_vs_long_data(self, wide_df) -> None: ...
    def test_flat_vector(self, long_df) -> None: ...
    def test_datetime_data(self, long_df) -> None: ...
    def test_empty_data(self) -> None: ...
    def test_a_deprecation(self, flat_series) -> None: ...
    def test_axis_deprecation(self, flat_series, variable) -> None: ...
    def test_vertical_deprecation(self, flat_series) -> None: ...
    def test_rug_data(self, flat_array) -> None: ...
    def test_rug_colors(self, long_df) -> None: ...
    def test_expand_margins(self, flat_array) -> None: ...
    def test_matplotlib_kwargs(self, flat_series) -> None: ...
    def test_axis_labels(self, flat_series) -> None: ...
    def test_log_scale(self, long_df) -> None: ...

class TestKDEPlotUnivariate:
    def test_long_vectors(self, long_df, variable) -> None: ...
    def test_wide_vs_long_data(self, wide_df) -> None: ...
    def test_flat_vector(self, long_df) -> None: ...
    def test_empty_data(self) -> None: ...
    def test_singular_data(self) -> None: ...
    def test_variable_assignment(self, long_df) -> None: ...
    def test_vertical_deprecation(self, long_df) -> None: ...
    def test_bw_deprecation(self, long_df) -> None: ...
    def test_kernel_deprecation(self, long_df) -> None: ...
    def test_shade_deprecation(self, long_df) -> None: ...
    def test_hue_colors(self, long_df, multiple) -> None: ...
    def test_hue_stacking(self, long_df) -> None: ...
    def test_hue_filling(self, long_df) -> None: ...
    def test_fill_default(self, long_df, multiple) -> None: ...
    def test_fill_nondefault(self, long_df, multiple) -> None: ...
    def test_color_cycle_interaction(self, flat_series) -> None: ...
    def test_color(self, long_df, fill) -> None: ...
    def test_datetime_scale(self, long_df) -> None: ...
    def test_multiple_argument_check(self, long_df) -> None: ...
    def test_cut(self, rng) -> None: ...
    def test_clip(self, rng) -> None: ...
    def test_line_is_density(self, long_df) -> None: ...
    def test_cumulative(self, long_df) -> None: ...
    def test_common_norm(self, long_df) -> None: ...
    def test_common_grid(self, long_df) -> None: ...
    def test_bw_method(self, long_df) -> None: ...
    def test_bw_adjust(self, long_df) -> None: ...
    def test_log_scale_implicit(self, rng) -> None: ...
    def test_log_scale_explicit(self, rng) -> None: ...
    def test_log_scale_with_hue(self, rng) -> None: ...
    def test_log_scale_normalization(self, rng) -> None: ...
    def test_weights(self) -> None: ...
    def test_sticky_edges(self, long_df) -> None: ...
    def test_line_kws(self, flat_array) -> None: ...
    def test_input_checking(self, long_df) -> None: ...
    def test_axis_labels(self, long_df) -> None: ...
    def test_legend(self, long_df) -> None: ...

class TestKDEPlotBivariate:
    def test_long_vectors(self, long_df) -> None: ...
    def test_singular_data(self) -> None: ...
    def test_fill_artists(self, long_df) -> None: ...
    def test_common_norm(self, rng) -> None: ...
    def test_log_scale(self, rng) -> None: ...
    def test_bandwidth(self, rng) -> None: ...
    def test_weights(self, rng) -> None: ...
    def test_hue_ignores_cmap(self, long_df) -> None: ...
    def test_contour_line_colors(self, long_df) -> None: ...
    def test_contour_fill_colors(self, long_df) -> None: ...
    def test_colorbar(self, long_df) -> None: ...
    def test_levels_and_thresh(self, long_df) -> None: ...
    def test_quantile_to_level(self, rng) -> None: ...
    def test_input_checking(self, long_df) -> None: ...

class TestHistPlotUnivariate:
    def test_long_vectors(self, long_df, variable) -> None: ...
    def test_wide_vs_long_data(self, wide_df) -> None: ...
    def test_flat_vector(self, long_df) -> None: ...
    def test_empty_data(self) -> None: ...
    def test_variable_assignment(self, long_df) -> None: ...
    def test_hue_fill_colors(self, long_df, multiple, element) -> None: ...
    def test_hue_stack(self, long_df) -> None: ...
    def test_hue_fill(self, long_df) -> None: ...
    def test_hue_dodge(self, long_df) -> None: ...
    def test_hue_as_numpy_dodged(self, long_df) -> None: ...
    def test_multiple_input_check(self, flat_series) -> None: ...
    def test_element_input_check(self, flat_series) -> None: ...
    def test_count_stat(self, flat_series) -> None: ...
    def test_density_stat(self, flat_series) -> None: ...
    def test_density_stat_common_norm(self, long_df) -> None: ...
    def test_density_stat_unique_norm(self, long_df) -> None: ...
    def height_norm_arg(self, request): ...
    def test_probability_stat(self, flat_series, height_norm_arg) -> None: ...
    def test_probability_stat_common_norm(self, long_df, height_norm_arg) -> None: ...
    def test_probability_stat_unique_norm(self, long_df, height_norm_arg) -> None: ...
    def test_percent_stat(self, flat_series) -> None: ...
    def test_common_bins(self, long_df) -> None: ...
    def test_unique_bins(self, wide_df) -> None: ...
    def test_weights_with_missing(self, missing_df) -> None: ...
    def test_discrete(self, long_df) -> None: ...
    def test_discrete_categorical_default(self, long_df) -> None: ...
    def test_categorical_yaxis_inversion(self, long_df) -> None: ...
    def test_discrete_requires_bars(self, long_df) -> None: ...
    def test_datetime_scale(self, long_df) -> None: ...
    def test_kde(self, flat_series, stat) -> None: ...
    def test_kde_with_hue(self, long_df, stat, multiple) -> None: ...
    def test_kde_default_cut(self, flat_series) -> None: ...
    def test_kde_hue(self, long_df) -> None: ...
    def test_kde_yaxis(self, flat_series) -> None: ...
    def test_kde_line_kws(self, flat_series) -> None: ...
    def test_kde_singular_data(self) -> None: ...
    def test_element_default(self, long_df) -> None: ...
    def test_bars_no_fill(self, flat_series) -> None: ...
    def test_step_fill(self, flat_series) -> None: ...
    def test_poly_fill(self, flat_series) -> None: ...
    def test_poly_no_fill(self, flat_series) -> None: ...
    def test_step_no_fill(self, flat_series) -> None: ...
    def test_step_fill_xy(self, flat_series) -> None: ...
    def test_step_no_fill_xy(self, flat_series) -> None: ...
    def test_weighted_histogram(self) -> None: ...
    def test_weights_with_auto_bins(self, long_df) -> None: ...
    def test_shrink(self, long_df) -> None: ...
    def test_log_scale_explicit(self, rng) -> None: ...
    def test_log_scale_implicit(self, rng) -> None: ...
    def test_auto_linewidth(self, flat_series, fill): ...
    def test_bar_kwargs(self, flat_series) -> None: ...
    def test_step_fill_kwargs(self, flat_series) -> None: ...
    def test_step_line_kwargs(self, flat_series) -> None: ...

class TestHistPlotBivariate:
    def test_mesh(self, long_df) -> None: ...
    def test_mesh_with_hue(self, long_df) -> None: ...
    def test_mesh_with_hue_unique_bins(self, long_df) -> None: ...
    def test_mesh_with_col_unique_bins(self, long_df) -> None: ...
    def test_mesh_log_scale(self, rng) -> None: ...
    def test_mesh_thresh(self, long_df) -> None: ...
    def test_mesh_sticky_edges(self, long_df) -> None: ...
    def test_mesh_common_norm(self, long_df) -> None: ...
    def test_mesh_unique_norm(self, long_df) -> None: ...
    def test_mesh_normalization(self, long_df, stat) -> None: ...
    def test_mesh_colors(self, long_df) -> None: ...
    def test_color_limits(self, long_df) -> None: ...
    def test_hue_color_limits(self, long_df) -> None: ...
    def test_colorbar(self, long_df) -> None: ...

class TestECDFPlotUnivariate:
    def test_long_vectors(self, long_df, variable) -> None: ...
    def test_hue(self, long_df) -> None: ...
    def test_line_kwargs(self, long_df) -> None: ...
    def test_drawstyle(self, flat_series, data_var) -> None: ...
    def test_proportion_limits(self, flat_series, data_var, stat_var) -> None: ...
    def test_proportion_limits_complementary(self, flat_series, data_var, stat_var) -> None: ...
    def test_proportion_count(self, flat_series, data_var, stat_var) -> None: ...
    def test_weights(self) -> None: ...
    def test_bivariate_error(self, long_df) -> None: ...
    def test_log_scale(self, long_df) -> None: ...

class TestDisPlot:
    def test_versus_single_histplot(self, long_df, kwargs) -> None: ...
    def test_versus_single_kdeplot(self, long_df, kwargs) -> None: ...
    def test_versus_single_ecdfplot(self, long_df, kwargs) -> None: ...
    def test_with_rug(self, long_df, kwargs) -> None: ...
    def test_facets(self, long_df, facet_var) -> None: ...
    def test_facet_multiple(self, long_df, multiple) -> None: ...
    def test_ax_warning(self, long_df) -> None: ...
    def test_array_faceting(self, long_df, key) -> None: ...
    def test_legend(self, long_df) -> None: ...
    def test_empty(self) -> None: ...
    def test_bivariate_ecdf_error(self, long_df) -> None: ...
    def test_bivariate_kde_norm(self, rng) -> None: ...
    def test_bivariate_hist_norm(self, rng) -> None: ...
    def test_facetgrid_data(self, long_df) -> None: ...
