from typing import Any

class _CategoricalPlotter:
    width: float
    default_palette: str
    require_numeric: bool
    orient: Any
    plot_data: Any
    group_label: Any
    value_label: Any
    group_names: Any
    plot_hues: Any
    hue_title: Any
    hue_names: Any
    plot_units: Any
    def establish_variables(self, x: Any | None = ..., y: Any | None = ..., hue: Any | None = ..., data: Any | None = ..., orient: Any | None = ..., order: Any | None = ..., hue_order: Any | None = ..., units: Any | None = ...) -> None: ...
    colors: Any
    gray: Any
    def establish_colors(self, color, palette, saturation) -> None: ...
    @property
    def hue_offsets(self): ...
    @property
    def nested_width(self): ...
    def annotate_axes(self, ax) -> None: ...
    def add_legend_data(self, ax, color, label) -> None: ...

class _BoxPlotter(_CategoricalPlotter):
    dodge: Any
    width: Any
    fliersize: Any
    linewidth: Any
    def __init__(self, x, y, hue, data, order, hue_order, orient, color, palette, saturation, width, dodge, fliersize, linewidth) -> None: ...
    def draw_boxplot(self, ax, kws) -> None: ...
    def restyle_boxplot(self, artist_dict, color, props) -> None: ...
    def plot(self, ax, boxplot_kws) -> None: ...

class _ViolinPlotter(_CategoricalPlotter):
    gridsize: Any
    width: Any
    dodge: Any
    inner: Any
    split: Any
    linewidth: Any
    def __init__(self, x, y, hue, data, order, hue_order, bw, cut, scale, scale_hue, gridsize, width, inner, split, dodge, orient, linewidth, color, palette, saturation) -> None: ...
    support: Any
    density: Any
    def estimate_densities(self, bw, cut, scale, scale_hue, gridsize) -> None: ...
    def fit_kde(self, x, bw): ...
    def kde_support(self, x, bw, cut, gridsize): ...
    def scale_area(self, density, max_density, scale_hue) -> None: ...
    def scale_width(self, density) -> None: ...
    def scale_count(self, density, counts, scale_hue) -> None: ...
    @property
    def dwidth(self): ...
    def draw_violins(self, ax) -> None: ...
    def draw_single_observation(self, ax, at_group, at_quant, density) -> None: ...
    def draw_box_lines(self, ax, data, support, density, center) -> None: ...
    def draw_quartiles(self, ax, data, support, density, center, split: bool = ...) -> None: ...
    def draw_points(self, ax, data, center) -> None: ...
    def draw_stick_lines(self, ax, data, support, density, center, split: bool = ...) -> None: ...
    def draw_to_density(self, ax, center, val, support, density, split, **kws) -> None: ...
    def plot(self, ax) -> None: ...

class _CategoricalScatterPlotter(_CategoricalPlotter):
    default_palette: str
    require_numeric: bool
    @property
    def point_colors(self): ...
    def add_legend_data(self, ax) -> None: ...

class _StripPlotter(_CategoricalScatterPlotter):
    dodge: Any
    width: float
    jitterer: Any
    def __init__(self, x, y, hue, data, order, hue_order, jitter, dodge, orient, color, palette) -> None: ...
    def draw_stripplot(self, ax, kws) -> None: ...
    def plot(self, ax, kws) -> None: ...

class _SwarmPlotter(_CategoricalScatterPlotter):
    dodge: Any
    width: float
    def __init__(self, x, y, hue, data, order, hue_order, dodge, orient, color, palette) -> None: ...
    def could_overlap(self, xy_i, swarm, d): ...
    def position_candidates(self, xy_i, neighbors, d): ...
    def first_non_overlapping_candidate(self, candidates, neighbors, d): ...
    def beeswarm(self, orig_xy, d): ...
    def add_gutters(self, points, center, width): ...
    def swarm_points(self, ax, points, center, width, s, **kws) -> None: ...
    def draw_swarmplot(self, ax, kws) -> None: ...
    def plot(self, ax, kws) -> None: ...

class _CategoricalStatPlotter(_CategoricalPlotter):
    require_numeric: bool
    @property
    def nested_width(self): ...
    statistic: Any
    confint: Any
    def estimate_statistic(self, estimator, ci, n_boot, seed) -> None: ...
    def draw_confints(self, ax, at_group, confint, colors, errwidth: Any | None = ..., capsize: Any | None = ..., **kws) -> None: ...

class _BarPlotter(_CategoricalStatPlotter):
    dodge: Any
    errcolor: Any
    errwidth: Any
    capsize: Any
    def __init__(self, x, y, hue, data, order, hue_order, estimator, ci, n_boot, units, seed, orient, color, palette, saturation, errcolor, errwidth, capsize, dodge) -> None: ...
    def draw_bars(self, ax, kws) -> None: ...
    def plot(self, ax, bar_kws) -> None: ...

class _PointPlotter(_CategoricalStatPlotter):
    default_palette: str
    colors: Any
    markers: Any
    linestyles: Any
    dodge: Any
    join: Any
    scale: Any
    errwidth: Any
    capsize: Any
    def __init__(self, x, y, hue, data, order, hue_order, estimator, ci, n_boot, units, seed, markers, linestyles, dodge, join, scale, orient, color, palette, errwidth: Any | None = ..., capsize: Any | None = ...) -> None: ...
    @property
    def hue_offsets(self): ...
    def draw_points(self, ax) -> None: ...
    def plot(self, ax) -> None: ...

class _CountPlotter(_BarPlotter):
    require_numeric: bool

class _LVPlotter(_CategoricalPlotter):
    width: Any
    dodge: Any
    saturation: Any
    k_depth: Any
    linewidth: Any
    scale: Any
    outlier_prop: Any
    trust_alpha: Any
    showfliers: Any
    def __init__(self, x, y, hue, data, order, hue_order, orient, color, palette, saturation, width, dodge, k_depth, linewidth, scale, outlier_prop, trust_alpha, showfliers: bool = ...) -> None: ...
    def draw_letter_value_plot(self, ax, kws) -> None: ...
    def plot(self, ax, boxplot_kws) -> None: ...

def boxplot(*, x: Any | None = ..., y: Any | None = ..., hue: Any | None = ..., data: Any | None = ..., order: Any | None = ..., hue_order: Any | None = ..., orient: Any | None = ..., color: Any | None = ..., palette: Any | None = ..., saturation: float = ..., width: float = ..., dodge: bool = ..., fliersize: int = ..., linewidth: Any | None = ..., whis: float = ..., ax: Any | None = ..., **kwargs): ...
def violinplot(*, x: Any | None = ..., y: Any | None = ..., hue: Any | None = ..., data: Any | None = ..., order: Any | None = ..., hue_order: Any | None = ..., bw: str = ..., cut: int = ..., scale: str = ..., scale_hue: bool = ..., gridsize: int = ..., width: float = ..., inner: str = ..., split: bool = ..., dodge: bool = ..., orient: Any | None = ..., linewidth: Any | None = ..., color: Any | None = ..., palette: Any | None = ..., saturation: float = ..., ax: Any | None = ..., **kwargs): ...
def boxenplot(*, x: Any | None = ..., y: Any | None = ..., hue: Any | None = ..., data: Any | None = ..., order: Any | None = ..., hue_order: Any | None = ..., orient: Any | None = ..., color: Any | None = ..., palette: Any | None = ..., saturation: float = ..., width: float = ..., dodge: bool = ..., k_depth: str = ..., linewidth: Any | None = ..., scale: str = ..., outlier_prop: float = ..., trust_alpha: float = ..., showfliers: bool = ..., ax: Any | None = ..., **kwargs): ...
def stripplot(*, x: Any | None = ..., y: Any | None = ..., hue: Any | None = ..., data: Any | None = ..., order: Any | None = ..., hue_order: Any | None = ..., jitter: bool = ..., dodge: bool = ..., orient: Any | None = ..., color: Any | None = ..., palette: Any | None = ..., size: int = ..., edgecolor: str = ..., linewidth: int = ..., ax: Any | None = ..., **kwargs): ...
def swarmplot(*, x: Any | None = ..., y: Any | None = ..., hue: Any | None = ..., data: Any | None = ..., order: Any | None = ..., hue_order: Any | None = ..., dodge: bool = ..., orient: Any | None = ..., color: Any | None = ..., palette: Any | None = ..., size: int = ..., edgecolor: str = ..., linewidth: int = ..., ax: Any | None = ..., **kwargs): ...
def barplot(*, x: Any | None = ..., y: Any | None = ..., hue: Any | None = ..., data: Any | None = ..., order: Any | None = ..., hue_order: Any | None = ..., estimator=..., ci: int = ..., n_boot: int = ..., units: Any | None = ..., seed: Any | None = ..., orient: Any | None = ..., color: Any | None = ..., palette: Any | None = ..., saturation: float = ..., errcolor: str = ..., errwidth: Any | None = ..., capsize: Any | None = ..., dodge: bool = ..., ax: Any | None = ..., **kwargs): ...
def pointplot(*, x: Any | None = ..., y: Any | None = ..., hue: Any | None = ..., data: Any | None = ..., order: Any | None = ..., hue_order: Any | None = ..., estimator=..., ci: int = ..., n_boot: int = ..., units: Any | None = ..., seed: Any | None = ..., markers: str = ..., linestyles: str = ..., dodge: bool = ..., join: bool = ..., scale: int = ..., orient: Any | None = ..., color: Any | None = ..., palette: Any | None = ..., errwidth: Any | None = ..., capsize: Any | None = ..., ax: Any | None = ..., **kwargs): ...
def countplot(*, x: Any | None = ..., y: Any | None = ..., hue: Any | None = ..., data: Any | None = ..., order: Any | None = ..., hue_order: Any | None = ..., orient: Any | None = ..., color: Any | None = ..., palette: Any | None = ..., saturation: float = ..., dodge: bool = ..., ax: Any | None = ..., **kwargs): ...
def factorplot(*args, **kwargs): ...
def catplot(*, x: Any | None = ..., y: Any | None = ..., hue: Any | None = ..., data: Any | None = ..., row: Any | None = ..., col: Any | None = ..., col_wrap: Any | None = ..., estimator=..., ci: int = ..., n_boot: int = ..., units: Any | None = ..., seed: Any | None = ..., order: Any | None = ..., hue_order: Any | None = ..., row_order: Any | None = ..., col_order: Any | None = ..., kind: str = ..., height: int = ..., aspect: int = ..., orient: Any | None = ..., color: Any | None = ..., palette: Any | None = ..., legend: bool = ..., legend_out: bool = ..., sharex: bool = ..., sharey: bool = ..., margin_titles: bool = ..., facet_kws: Any | None = ..., **kwargs): ...
