from typing import Any

class _BaseGrid:
    def set(self, **kwargs): ...
    @property
    def fig(self): ...
    @property
    def figure(self): ...
    def savefig(self, *args, **kwargs) -> None: ...

class Grid(_BaseGrid):
    def __init__(self) -> None: ...
    def tight_layout(self, *args, **kwargs) -> None: ...
    def add_legend(self, legend_data: Any | None = ..., title: Any | None = ..., label_order: Any | None = ..., adjust_subtitles: bool = ..., **kwargs): ...
    @property
    def legend(self): ...

class FacetGrid(Grid):
    data: Any
    row_names: Any
    col_names: Any
    hue_names: Any
    hue_kws: Any
    def __init__(self, data, *, row: Any | None = ..., col: Any | None = ..., hue: Any | None = ..., col_wrap: Any | None = ..., sharex: bool = ..., sharey: bool = ..., height: int = ..., aspect: int = ..., palette: Any | None = ..., row_order: Any | None = ..., col_order: Any | None = ..., hue_order: Any | None = ..., hue_kws: Any | None = ..., dropna: bool = ..., legend_out: bool = ..., despine: bool = ..., margin_titles: bool = ..., xlim: Any | None = ..., ylim: Any | None = ..., subplot_kws: Any | None = ..., gridspec_kws: Any | None = ..., size: Any | None = ...) -> None: ...
    def facet_data(self) -> None: ...
    def map(self, func, *args, **kwargs): ...
    def map_dataframe(self, func, *args, **kwargs): ...
    def facet_axis(self, row_i, col_j, modify_state: bool = ...): ...
    def despine(self, **kwargs): ...
    def set_axis_labels(self, x_var: Any | None = ..., y_var: Any | None = ..., clear_inner: bool = ..., **kwargs): ...
    def set_xlabels(self, label: Any | None = ..., clear_inner: bool = ..., **kwargs): ...
    def set_ylabels(self, label: Any | None = ..., clear_inner: bool = ..., **kwargs): ...
    def set_xticklabels(self, labels: Any | None = ..., step: Any | None = ..., **kwargs): ...
    def set_yticklabels(self, labels: Any | None = ..., **kwargs): ...
    def set_titles(self, template: Any | None = ..., row_template: Any | None = ..., col_template: Any | None = ..., **kwargs): ...
    def refline(self, *, x: Any | None = ..., y: Any | None = ..., color: str = ..., linestyle: str = ..., **line_kws) -> None: ...
    @property
    def axes(self): ...
    @property
    def ax(self): ...
    @property
    def axes_dict(self): ...

class PairGrid(Grid):
    x_vars: Any
    y_vars: Any
    square_grid: Any
    axes: Any
    data: Any
    diag_sharey: Any
    diag_vars: Any
    diag_axes: Any
    hue_names: Any
    hue_vals: Any
    hue_kws: Any
    palette: Any
    def __init__(self, data, *, hue: Any | None = ..., hue_order: Any | None = ..., palette: Any | None = ..., hue_kws: Any | None = ..., vars: Any | None = ..., x_vars: Any | None = ..., y_vars: Any | None = ..., corner: bool = ..., diag_sharey: bool = ..., height: float = ..., aspect: int = ..., layout_pad: float = ..., despine: bool = ..., dropna: bool = ..., size: Any | None = ...) -> None: ...
    def map(self, func, **kwargs): ...
    def map_lower(self, func, **kwargs): ...
    def map_upper(self, func, **kwargs): ...
    def map_offdiag(self, func, **kwargs): ...
    def map_diag(self, func, **kwargs): ...

class JointGrid(_BaseGrid):
    ax_joint: Any
    ax_marg_x: Any
    ax_marg_y: Any
    x: Any
    y: Any
    hue: Any
    def __init__(self, *, x: Any | None = ..., y: Any | None = ..., data: Any | None = ..., height: int = ..., ratio: int = ..., space: float = ..., dropna: bool = ..., xlim: Any | None = ..., ylim: Any | None = ..., size: Any | None = ..., marginal_ticks: bool = ..., hue: Any | None = ..., palette: Any | None = ..., hue_order: Any | None = ..., hue_norm: Any | None = ...): ...
    def plot(self, joint_func, marginal_func, **kwargs): ...
    def plot_joint(self, func, **kwargs): ...
    def plot_marginals(self, func, **kwargs): ...
    def refline(self, *, x: Any | None = ..., y: Any | None = ..., joint: bool = ..., marginal: bool = ..., color: str = ..., linestyle: str = ..., **line_kws): ...
    def set_axis_labels(self, xlabel: str = ..., ylabel: str = ..., **kwargs): ...

def pairplot(data, *, hue: Any | None = ..., hue_order: Any | None = ..., palette: Any | None = ..., vars: Any | None = ..., x_vars: Any | None = ..., y_vars: Any | None = ..., kind: str = ..., diag_kind: str = ..., markers: Any | None = ..., height: float = ..., aspect: int = ..., corner: bool = ..., dropna: bool = ..., plot_kws: Any | None = ..., diag_kws: Any | None = ..., grid_kws: Any | None = ..., size: Any | None = ...): ...
def jointplot(*, x: Any | None = ..., y: Any | None = ..., data: Any | None = ..., kind: str = ..., color: Any | None = ..., height: int = ..., ratio: int = ..., space: float = ..., dropna: bool = ..., xlim: Any | None = ..., ylim: Any | None = ..., marginal_ticks: bool = ..., joint_kws: Any | None = ..., marginal_kws: Any | None = ..., hue: Any | None = ..., palette: Any | None = ..., hue_order: Any | None = ..., hue_norm: Any | None = ..., **kwargs): ...
