from ._decorators import share_init_params_with_map as share_init_params_with_map
from .palettes import QUAL_PALETTES as QUAL_PALETTES, color_palette as color_palette
from .utils import get_color_cycle as get_color_cycle, remove_na as remove_na
from typing import Any

class SemanticMapping:
    map_type: Any
    levels: Any
    lookup_table: Any
    plotter: Any
    def __init__(self, plotter) -> None: ...
    def map(cls, plotter, *args, **kwargs): ...
    def __call__(self, key, *args, **kwargs): ...

class HueMapping(SemanticMapping):
    palette: Any
    norm: Any
    cmap: Any
    map_type: Any
    lookup_table: Any
    levels: Any
    def __init__(self, plotter, palette: Any | None = ..., order: Any | None = ..., norm: Any | None = ...) -> None: ...
    def infer_map_type(self, palette, norm, input_format, var_type): ...
    def categorical_mapping(self, data, palette, order): ...
    def numeric_mapping(self, data, palette, norm): ...

class SizeMapping(SemanticMapping):
    norm: Any
    map_type: Any
    levels: Any
    sizes: Any
    size_range: Any
    lookup_table: Any
    def __init__(self, plotter, sizes: Any | None = ..., order: Any | None = ..., norm: Any | None = ...) -> None: ...
    def infer_map_type(self, norm, sizes, var_type): ...
    def categorical_mapping(self, data, sizes, order): ...
    def numeric_mapping(self, data, sizes, norm): ...

class StyleMapping(SemanticMapping):
    map_type: str
    levels: Any
    lookup_table: Any
    def __init__(self, plotter, markers: Any | None = ..., dashes: Any | None = ..., order: Any | None = ...) -> None: ...

class VectorPlotter:
    semantics: Any
    wide_structure: Any
    flat_structure: Any
    def __init__(self, data: Any | None = ..., variables=...) -> None: ...
    @classmethod
    def get_semantics(cls, kwargs, semantics: Any | None = ...): ...
    @property
    def has_xy_data(self): ...
    @property
    def var_levels(self): ...
    input_format: str
    plot_data: Any
    variables: Any
    var_types: Any
    def assign_variables(self, data: Any | None = ..., variables=...): ...
    def iter_data(self, grouping_vars: Any | None = ..., reverse: bool = ..., from_comp_data: bool = ...) -> None: ...
    @property
    def comp_data(self): ...

def variable_type(vector, boolean_type: str = ...): ...
def infer_orient(x: Any | None = ..., y: Any | None = ..., orient: Any | None = ..., require_numeric: bool = ...): ...
def unique_dashes(n): ...
def unique_markers(n): ...
def categorical_order(vector, order: Any | None = ...): ...
