from datetime import datetime
from dateutil.relativedelta import FR as FR, SA as SA, SU as SU, TU as TU, WE as WE
from pandas import DateOffset as DateOffset, DatetimeIndex as DatetimeIndex, Series as Series, Timestamp as Timestamp, concat as concat, date_range as date_range
from pandas.errors import PerformanceWarning as PerformanceWarning
from pandas.tseries.offsets import Day as Day, Easter as Easter
from typing import Union, Any

def next_monday(dt: datetime) -> datetime: ...
def next_monday_or_tuesday(dt: datetime) -> datetime: ...
def previous_friday(dt: datetime) -> datetime: ...
def sunday_to_monday(dt: datetime) -> datetime: ...
def weekend_to_monday(dt: datetime) -> datetime: ...
def nearest_workday(dt: datetime) -> datetime: ...
def next_workday(dt: datetime) -> datetime: ...
def previous_workday(dt: datetime) -> datetime: ...
def before_nearest_workday(dt: datetime) -> datetime: ...
def after_nearest_workday(dt: datetime) -> datetime: ...

class Holiday:
    name: Any
    year: Any
    month: Any
    day: Any
    offset: Any
    start_date: Any
    end_date: Any
    observance: Any
    days_of_week: Any
    def __init__(self, name, year: Any | None = ..., month: Any | None = ..., day: Any | None = ..., offset: Any | None = ..., observance: Any | None = ..., start_date: Any | None = ..., end_date: Any | None = ..., days_of_week: Any | None = ...) -> None: ...
    def dates(self, start_date, end_date, return_name: bool = ...): ...

holiday_calendars: Any

def register(cls) -> None: ...
def get_calendar(name): ...

class HolidayCalendarMetaClass(type):
    def __new__(cls, clsname, bases, attrs): ...

class AbstractHolidayCalendar(metaclass=HolidayCalendarMetaClass):
    rules: list[Holiday]
    start_date: Any
    end_date: Any
    name: Any
    def __init__(self, name: Any | None = ..., rules: Any | None = ...) -> None: ...
    def rule_from_name(self, name): ...
    def holidays(self, start: Any | None = ..., end: Any | None = ..., return_name: bool = ...): ...
    @staticmethod
    def merge_class(base, other): ...
    def merge(self, other, inplace: bool = ...): ...

USMemorialDay: Any
USLaborDay: Any
USColumbusDay: Any
USThanksgivingDay: Any
USMartinLutherKingJr: Any
USPresidentsDay: Any
GoodFriday: Any
EasterMonday: Any

class USFederalHolidayCalendar(AbstractHolidayCalendar):
    rules: Any

def HolidayCalendarFactory(name, base, other, base_class=...): ...
