import matplotlib.dates as dates
import numpy as np
import matplotlib.units as units
from datetime import tzinfo
from matplotlib.ticker import Formatter, Locator
from pandas import Index as Index, Series as Series, get_option as get_option
from pandas._libs import lib as lib
from pandas._libs.tslibs import Timestamp as Timestamp, to_offset as to_offset
from pandas._libs.tslibs.dtypes import FreqGroup as FreqGroup
from pandas._libs.tslibs.offsets import BaseOffset as BaseOffset
from pandas._typing import F as F
from pandas.core.dtypes.common import is_float as is_float, is_float_dtype as is_float_dtype, is_integer as is_integer, is_integer_dtype as is_integer_dtype, is_nested_list_like as is_nested_list_like
from pandas.core.indexes.datetimes import date_range as date_range
from pandas.core.indexes.period import Period as Period, PeriodIndex as PeriodIndex, period_range as period_range
from typing import Union, Any

HOURS_PER_DAY: float
MIN_PER_HOUR: float
SEC_PER_MIN: float
SEC_PER_HOUR: Any
SEC_PER_DAY: Any
MUSEC_PER_DAY: Any

def get_pairs(): ...
def register_pandas_matplotlib_converters(func: F) -> F: ...
def pandas_converters() -> None: ...
def register() -> None: ...
def deregister() -> None: ...
def time2num(d): ...

class TimeConverter(units.ConversionInterface):
    @staticmethod
    def convert(value, unit, axis): ...
    @staticmethod
    def axisinfo(unit, axis) -> Union[units.AxisInfo, None]: ...
    @staticmethod
    def default_units(x, axis) -> str: ...

class TimeFormatter(Formatter):
    locs: Any
    def __init__(self, locs) -> None: ...
    def __call__(self, x, pos: int = ...) -> str: ...

class PeriodConverter(dates.DateConverter):
    @staticmethod
    def convert(values, units, axis): ...

def get_datevalue(date, freq): ...

class DatetimeConverter(dates.DateConverter):
    @staticmethod
    def convert(values, unit, axis): ...
    @staticmethod
    def axisinfo(unit: Union[tzinfo, None], axis) -> units.AxisInfo: ...

class PandasAutoDateFormatter(dates.AutoDateFormatter):
    def __init__(self, locator, tz: Any | None = ..., defaultfmt: str = ...) -> None: ...

class PandasAutoDateLocator(dates.AutoDateLocator):
    def get_locator(self, dmin, dmax): ...

class MilliSecondLocator(dates.DateLocator):
    UNIT: Any
    def __init__(self, tz) -> None: ...
    @staticmethod
    def get_unit_generic(freq): ...
    def __call__(self): ...
    def autoscale(self): ...

def period_break(dates: PeriodIndex, period: str) -> np.ndarray: ...
def has_level_label(label_flags: np.ndarray, vmin: float) -> bool: ...
def get_finder(freq: BaseOffset): ...

class TimeSeries_DateLocator(Locator):
    freq: Any
    base: Any
    isminor: Any
    isdynamic: Any
    offset: int
    plot_obj: Any
    finder: Any
    def __init__(self, freq, minor_locator: bool = ..., dynamic_mode: bool = ..., base: int = ..., quarter: int = ..., month: int = ..., day: int = ..., plot_obj: Any | None = ...) -> None: ...
    def __call__(self): ...
    def autoscale(self): ...

class TimeSeries_DateFormatter(Formatter):
    format: Any
    freq: Any
    locs: Any
    formatdict: Any
    isminor: Any
    isdynamic: Any
    offset: int
    plot_obj: Any
    finder: Any
    def __init__(self, freq, minor_locator: bool = ..., dynamic_mode: bool = ..., plot_obj: Any | None = ...) -> None: ...
    def set_locs(self, locs) -> None: ...
    def __call__(self, x, pos: int = ...) -> str: ...

class TimeSeries_TimedeltaFormatter(Formatter):
    @staticmethod
    def format_timedelta_ticks(x, pos, n_decimals: int) -> str: ...
    def __call__(self, x, pos: int = ...) -> str: ...
