from pandas import get_option as get_option
from pandas._typing import DtypeArg as DtypeArg
from pandas.compat._optional import import_optional_dependency as import_optional_dependency
from pandas.core.api import DataFrame as DataFrame, Series as Series
from pandas.core.base import PandasObject as PandasObject
from pandas.core.dtypes.common import is_datetime64tz_dtype as is_datetime64tz_dtype, is_dict_like as is_dict_like, is_list_like as is_list_like
from pandas.core.dtypes.dtypes import DatetimeTZDtype as DatetimeTZDtype
from pandas.core.dtypes.missing import isna as isna
from pandas.core.tools.datetimes import to_datetime as to_datetime
from pandas.errors import AbstractMethodError as AbstractMethodError
from pandas.util._exceptions import find_stack_level as find_stack_level
from pandas.util.version import Version as Version
from typing import Union, Any, Iterator, Sequence, overload

class DatabaseError(OSError): ...

def execute(sql, con, params: Any | None = ...): ...
@overload
def read_sql_table(table_name, con, schema=..., index_col=..., coerce_float=..., parse_dates=..., columns=..., chunksize: None = ...) -> DataFrame: ...
@overload
def read_sql_table(table_name, con, schema=..., index_col=..., coerce_float=..., parse_dates=..., columns=..., chunksize: int = ...) -> Iterator[DataFrame]: ...
@overload
def read_sql_query(sql, con, index_col=..., coerce_float=..., params=..., parse_dates=..., chunksize: None = ..., dtype: Union[DtypeArg, None] = ...) -> DataFrame: ...
@overload
def read_sql_query(sql, con, index_col=..., coerce_float=..., params=..., parse_dates=..., chunksize: int = ..., dtype: Union[DtypeArg, None] = ...) -> Iterator[DataFrame]: ...
@overload
def read_sql(sql, con, index_col=..., coerce_float=..., params=..., parse_dates=..., columns=..., chunksize: None = ...) -> DataFrame: ...
@overload
def read_sql(sql, con, index_col=..., coerce_float=..., params=..., parse_dates=..., columns=..., chunksize: int = ...) -> Iterator[DataFrame]: ...
def to_sql(frame, name: str, con, schema: Union[str, None] = ..., if_exists: str = ..., index: bool = ..., index_label: Any | None = ..., chunksize: Union[int, None] = ..., dtype: Union[DtypeArg, None] = ..., method: Union[str, None] = ..., engine: str = ..., **engine_kwargs) -> Union[int, None]: ...
def has_table(table_name: str, con, schema: Union[str, None] = ...): ...
table_exists = has_table

def pandasSQL_builder(con, schema: Union[str, None] = ...): ...

class SQLTable(PandasObject):
    name: Any
    pd_sql: Any
    prefix: Any
    frame: Any
    index: Any
    schema: Any
    if_exists: Any
    keys: Any
    dtype: Any
    table: Any
    def __init__(self, name: str, pandas_sql_engine, frame: Any | None = ..., index: bool = ..., if_exists: str = ..., prefix: str = ..., index_label: Any | None = ..., schema: Any | None = ..., keys: Any | None = ..., dtype: Union[DtypeArg, None] = ...) -> None: ...
    def exists(self): ...
    def sql_schema(self): ...
    def create(self) -> None: ...
    def insert_data(self): ...
    def insert(self, chunksize: Union[int, None] = ..., method: Union[str, None] = ...) -> Union[int, None]: ...
    def read(self, coerce_float: bool = ..., parse_dates: Any | None = ..., columns: Any | None = ..., chunksize: Any | None = ...): ...

class PandasSQL(PandasObject):
    def read_sql(self, *args, **kwargs) -> None: ...
    def to_sql(self, frame, name, if_exists: str = ..., index: bool = ..., index_label: Any | None = ..., schema: Any | None = ..., chunksize: Any | None = ..., dtype: Union[DtypeArg, None] = ..., method: Any | None = ...) -> Union[int, None]: ...

class BaseEngine:
    def insert_records(self, table: SQLTable, con, frame, name, index: bool = ..., schema: Any | None = ..., chunksize: Any | None = ..., method: Any | None = ..., **engine_kwargs) -> Union[int, None]: ...

class SQLAlchemyEngine(BaseEngine):
    def __init__(self) -> None: ...
    def insert_records(self, table: SQLTable, con, frame, name, index: bool = ..., schema: Any | None = ..., chunksize: Any | None = ..., method: Any | None = ..., **engine_kwargs) -> Union[int, None]: ...

def get_engine(engine: str) -> BaseEngine: ...

class SQLDatabase(PandasSQL):
    connectable: Any
    meta: Any
    def __init__(self, engine, schema: Union[str, None] = ...) -> None: ...
    def run_transaction(self) -> None: ...
    def execute(self, *args, **kwargs): ...
    def read_table(self, table_name: str, index_col: Union[str, Sequence[str], None] = ..., coerce_float: bool = ..., parse_dates: Any | None = ..., columns: Any | None = ..., schema: Union[str, None] = ..., chunksize: Union[int, None] = ...): ...
    def read_query(self, sql: str, index_col: Union[str, None] = ..., coerce_float: bool = ..., parse_dates: Any | None = ..., params: Any | None = ..., chunksize: Union[int, None] = ..., dtype: Union[DtypeArg, None] = ...): ...
    read_sql: Any
    def prep_table(self, frame, name, if_exists: str = ..., index: bool = ..., index_label: Any | None = ..., schema: Any | None = ..., dtype: Union[DtypeArg, None] = ...) -> SQLTable: ...
    def check_case_sensitive(self, name, schema) -> None: ...
    def to_sql(self, frame, name, if_exists: str = ..., index: bool = ..., index_label: Any | None = ..., schema: Any | None = ..., chunksize: Any | None = ..., dtype: Union[DtypeArg, None] = ..., method: Any | None = ..., engine: str = ..., **engine_kwargs) -> Union[int, None]: ...
    @property
    def tables(self): ...
    def has_table(self, name: str, schema: Union[str, None] = ...): ...
    def get_table(self, table_name: str, schema: Union[str, None] = ...): ...
    def drop_table(self, table_name: str, schema: Union[str, None] = ...): ...

class SQLiteTable(SQLTable):
    def __init__(self, *args, **kwargs): ...
    def sql_schema(self): ...
    def insert_statement(self, num_rows: int): ...

class SQLiteDatabase(PandasSQL):
    con: Any
    def __init__(self, con) -> None: ...
    def run_transaction(self) -> None: ...
    def execute(self, *args, **kwargs): ...
    def read_query(self, sql, index_col: Any | None = ..., coerce_float: bool = ..., params: Any | None = ..., parse_dates: Any | None = ..., chunksize: Union[int, None] = ..., dtype: Union[DtypeArg, None] = ...): ...
    def to_sql(self, frame, name, if_exists: str = ..., index: bool = ..., index_label: Any | None = ..., schema: Any | None = ..., chunksize: Any | None = ..., dtype: Union[DtypeArg, None] = ..., method: Any | None = ..., **kwargs) -> Union[int, None]: ...
    def has_table(self, name: str, schema: Union[str, None] = ...): ...
    def get_table(self, table_name: str, schema: Union[str, None] = ...): ...
    def drop_table(self, name: str, schema: Union[str, None] = ...): ...

def get_schema(frame, name: str, keys: Any | None = ..., con: Any | None = ..., dtype: Union[DtypeArg, None] = ..., schema: Union[str, None] = ...): ...
