import numpy as np
from pandas import DataFrame as DataFrame, DatetimeIndex as DatetimeIndex, Index as Index, MultiIndex as MultiIndex, PeriodIndex as PeriodIndex, Series as Series, TimedeltaIndex as TimedeltaIndex, concat as concat, isna as isna
from pandas._config import config as config, get_option as get_option
from pandas._libs import lib as lib
from pandas._libs.tslibs import timezones as timezones
from pandas._typing import ArrayLike as ArrayLike, DtypeArg as DtypeArg, Shape as Shape
from pandas.compat._optional import import_optional_dependency as import_optional_dependency
from pandas.compat.pickle_compat import patch_pickle as patch_pickle
from pandas.core.api import Int64Index as Int64Index
from pandas.core.arrays import Categorical as Categorical, DatetimeArray as DatetimeArray, PeriodArray as PeriodArray
from pandas.core.computation.pytables import PyTablesExpr as PyTablesExpr, maybe_expression as maybe_expression
from pandas.core.construction import extract_array as extract_array
from pandas.core.dtypes.common import ensure_object as ensure_object, is_categorical_dtype as is_categorical_dtype, is_complex_dtype as is_complex_dtype, is_datetime64_dtype as is_datetime64_dtype, is_datetime64tz_dtype as is_datetime64tz_dtype, is_extension_array_dtype as is_extension_array_dtype, is_list_like as is_list_like, is_string_dtype as is_string_dtype, is_timedelta64_dtype as is_timedelta64_dtype, needs_i8_conversion as needs_i8_conversion
from pandas.core.dtypes.missing import array_equivalent as array_equivalent
from pandas.core.indexes.api import ensure_index as ensure_index
from pandas.core.internals import ArrayManager as ArrayManager, Block as Block, BlockManager as BlockManager
from pandas.errors import PerformanceWarning as PerformanceWarning
from pandas.io.common import stringify_path as stringify_path
from pandas.io.formats.printing import adjoin as adjoin, pprint_thing as pprint_thing
from pandas.util._decorators import cache_readonly as cache_readonly
from pandas.util._exceptions import find_stack_level as find_stack_level
from tables import Col as Col, File as File, Node as Node
from typing import Union, Any, Hashable, Literal

Term = PyTablesExpr

class PossibleDataLossError(Exception): ...
class ClosedFileError(Exception): ...
class IncompatibilityWarning(Warning): ...

incompatibility_doc: str

class AttributeConflictWarning(Warning): ...

attribute_conflict_doc: str

class DuplicateWarning(Warning): ...

duplicate_doc: str
performance_doc: str
dropna_doc: str
format_doc: str

def to_hdf(path_or_buf, key: str, value: Union[DataFrame, Series], mode: str = ..., complevel: Union[int, None] = ..., complib: Union[str, None] = ..., append: bool = ..., format: Union[str, None] = ..., index: bool = ..., min_itemsize: Union[int, dict[str, int], None] = ..., nan_rep: Any | None = ..., dropna: Union[bool, None] = ..., data_columns: Union[Literal[True], list[str], None] = ..., errors: str = ..., encoding: str = ...) -> None: ...
def read_hdf(path_or_buf, key: Any | None = ..., mode: str = ..., errors: str = ..., where: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ..., columns: Any | None = ..., iterator: bool = ..., chunksize: Union[int, None] = ..., **kwargs): ...

class HDFStore:
    def __init__(self, path, mode: str = ..., complevel: Union[int, None] = ..., complib: Any | None = ..., fletcher32: bool = ..., **kwargs) -> None: ...
    def __fspath__(self): ...
    @property
    def root(self): ...
    @property
    def filename(self): ...
    def __getitem__(self, key: str): ...
    def __setitem__(self, key: str, value): ...
    def __delitem__(self, key: str): ...
    def __getattr__(self, name: str): ...
    def __contains__(self, key: str) -> bool: ...
    def __len__(self) -> int: ...
    def __enter__(self): ...
    def __exit__(self, exc_type, exc_value, traceback) -> None: ...
    def keys(self, include: str = ...) -> list[str]: ...
    def __iter__(self): ...
    def items(self) -> None: ...
    iteritems: Any
    def open(self, mode: str = ..., **kwargs): ...
    def close(self) -> None: ...
    @property
    def is_open(self) -> bool: ...
    def flush(self, fsync: bool = ...): ...
    def get(self, key: str): ...
    def select(self, key: str, where: Any | None = ..., start: Any | None = ..., stop: Any | None = ..., columns: Any | None = ..., iterator: bool = ..., chunksize: Any | None = ..., auto_close: bool = ...): ...
    def select_as_coordinates(self, key: str, where: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...): ...
    def select_column(self, key: str, column: str, start: Union[int, None] = ..., stop: Union[int, None] = ...): ...
    def select_as_multiple(self, keys, where: Any | None = ..., selector: Any | None = ..., columns: Any | None = ..., start: Any | None = ..., stop: Any | None = ..., iterator: bool = ..., chunksize: Any | None = ..., auto_close: bool = ...): ...
    def put(self, key: str, value: Union[DataFrame, Series], format: Any | None = ..., index: bool = ..., append: bool = ..., complib: Any | None = ..., complevel: Union[int, None] = ..., min_itemsize: Union[int, dict[str, int], None] = ..., nan_rep: Any | None = ..., data_columns: Union[Literal[True], list[str], None] = ..., encoding: Any | None = ..., errors: str = ..., track_times: bool = ..., dropna: bool = ...): ...
    def remove(self, key: str, where: Any | None = ..., start: Any | None = ..., stop: Any | None = ...): ...
    def append(self, key: str, value: Union[DataFrame, Series], format: Any | None = ..., axes: Any | None = ..., index: bool = ..., append: bool = ..., complib: Any | None = ..., complevel: Union[int, None] = ..., columns: Any | None = ..., min_itemsize: Union[int, dict[str, int], None] = ..., nan_rep: Any | None = ..., chunksize: Any | None = ..., expectedrows: Any | None = ..., dropna: Union[bool, None] = ..., data_columns: Union[Literal[True], list[str], None] = ..., encoding: Any | None = ..., errors: str = ...): ...
    def append_to_multiple(self, d: dict, value, selector, data_columns: Any | None = ..., axes: Any | None = ..., dropna: bool = ..., **kwargs): ...
    def create_table_index(self, key: str, columns: Any | None = ..., optlevel: Union[int, None] = ..., kind: Union[str, None] = ...): ...
    def groups(self): ...
    def walk(self, where: str = ...) -> None: ...
    def get_node(self, key: str) -> Union[Node, None]: ...
    def get_storer(self, key: str) -> Union[GenericFixed, Table]: ...
    def copy(self, file, mode: str = ..., propindexes: bool = ..., keys: Any | None = ..., complib: Any | None = ..., complevel: Union[int, None] = ..., fletcher32: bool = ..., overwrite: bool = ...): ...
    def info(self) -> str: ...

class TableIterator:
    chunksize: Union[int, None]
    store: HDFStore
    s: Union[GenericFixed, Table]
    func: Any
    where: Any
    nrows: Any
    start: Any
    stop: Any
    coordinates: Any
    auto_close: Any
    def __init__(self, store: HDFStore, s: Union[GenericFixed, Table], func, where, nrows, start: Any | None = ..., stop: Any | None = ..., iterator: bool = ..., chunksize: Union[int, None] = ..., auto_close: bool = ...) -> None: ...
    def __iter__(self): ...
    def close(self) -> None: ...
    def get_result(self, coordinates: bool = ...): ...

class IndexCol:
    is_an_indexable: bool
    is_data_indexable: bool
    name: str
    cname: str
    values: Any
    kind: Any
    typ: Any
    axis: Any
    pos: Any
    freq: Any
    tz: Any
    index_name: Any
    ordered: Any
    table: Any
    meta: Any
    metadata: Any
    def __init__(self, name: str, values: Any | None = ..., kind: Any | None = ..., typ: Any | None = ..., cname: Union[str, None] = ..., axis: Any | None = ..., pos: Any | None = ..., freq: Any | None = ..., tz: Any | None = ..., index_name: Any | None = ..., ordered: Any | None = ..., table: Any | None = ..., meta: Any | None = ..., metadata: Any | None = ...) -> None: ...
    @property
    def itemsize(self) -> int: ...
    @property
    def kind_attr(self) -> str: ...
    def set_pos(self, pos: int): ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other) -> bool: ...
    @property
    def is_indexed(self) -> bool: ...
    def convert(self, values: np.ndarray, nan_rep, encoding: str, errors: str): ...
    def take_data(self): ...
    @property
    def attrs(self): ...
    @property
    def description(self): ...
    @property
    def col(self): ...
    @property
    def cvalues(self): ...
    def __iter__(self): ...
    def maybe_set_size(self, min_itemsize: Any | None = ...) -> None: ...
    def validate_names(self) -> None: ...
    def validate_and_set(self, handler: AppendableTable, append: bool): ...
    def validate_col(self, itemsize: Any | None = ...): ...
    def validate_attr(self, append: bool): ...
    def update_info(self, info) -> None: ...
    def set_info(self, info) -> None: ...
    def set_attr(self) -> None: ...
    def validate_metadata(self, handler: AppendableTable): ...
    def write_metadata(self, handler: AppendableTable): ...

class GenericIndexCol(IndexCol):
    @property
    def is_indexed(self) -> bool: ...
    def convert(self, values: np.ndarray, nan_rep, encoding: str, errors: str): ...
    def set_attr(self) -> None: ...

class DataCol(IndexCol):
    is_an_indexable: bool
    is_data_indexable: bool
    dtype: Any
    data: Any
    def __init__(self, name: str, values: Any | None = ..., kind: Any | None = ..., typ: Any | None = ..., cname: Any | None = ..., pos: Any | None = ..., tz: Any | None = ..., ordered: Any | None = ..., table: Any | None = ..., meta: Any | None = ..., metadata: Any | None = ..., dtype: Union[DtypeArg, None] = ..., data: Any | None = ...) -> None: ...
    @property
    def dtype_attr(self) -> str: ...
    @property
    def meta_attr(self) -> str: ...
    def __eq__(self, other: Any) -> bool: ...
    kind: Any
    def set_data(self, data: ArrayLike): ...
    def take_data(self): ...
    @classmethod
    def get_atom_string(cls, shape, itemsize): ...
    @classmethod
    def get_atom_coltype(cls, kind: str) -> type[Col]: ...
    @classmethod
    def get_atom_data(cls, shape, kind: str) -> Col: ...
    @classmethod
    def get_atom_datetime64(cls, shape): ...
    @classmethod
    def get_atom_timedelta64(cls, shape): ...
    @property
    def shape(self): ...
    @property
    def cvalues(self): ...
    def validate_attr(self, append) -> None: ...
    def convert(self, values: np.ndarray, nan_rep, encoding: str, errors: str): ...
    def set_attr(self) -> None: ...

class DataIndexableCol(DataCol):
    is_data_indexable: bool
    def validate_names(self) -> None: ...
    @classmethod
    def get_atom_string(cls, shape, itemsize): ...
    @classmethod
    def get_atom_data(cls, shape, kind: str) -> Col: ...
    @classmethod
    def get_atom_datetime64(cls, shape): ...
    @classmethod
    def get_atom_timedelta64(cls, shape): ...

class GenericDataIndexableCol(DataIndexableCol): ...

class Fixed:
    pandas_kind: str
    format_type: str
    obj_type: type[Union[DataFrame, Series]]
    ndim: int
    encoding: str
    parent: HDFStore
    group: Node
    errors: str
    is_table: bool
    def __init__(self, parent: HDFStore, group: Node, encoding: str = ..., errors: str = ...) -> None: ...
    @property
    def is_old_version(self) -> bool: ...
    @property
    def version(self) -> tuple[int, int, int]: ...
    @property
    def pandas_type(self): ...
    def set_object_info(self) -> None: ...
    def copy(self): ...
    @property
    def shape(self): ...
    @property
    def pathname(self): ...
    @property
    def attrs(self): ...
    def set_attrs(self) -> None: ...
    def get_attrs(self) -> None: ...
    @property
    def storable(self): ...
    @property
    def is_exists(self) -> bool: ...
    @property
    def nrows(self): ...
    def validate(self, other): ...
    def validate_version(self, where: Any | None = ...): ...
    def infer_axes(self): ...
    def read(self, where: Any | None = ..., columns: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...): ...
    def write(self, **kwargs) -> None: ...
    def delete(self, where: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...): ...

class GenericFixed(Fixed):
    attributes: list[str]
    def validate_read(self, columns, where) -> None: ...
    @property
    def is_exists(self) -> bool: ...
    def set_attrs(self) -> None: ...
    encoding: Any
    errors: Any
    def get_attrs(self) -> None: ...
    def write(self, obj, **kwargs) -> None: ...
    def read_array(self, key: str, start: Union[int, None] = ..., stop: Union[int, None] = ...): ...
    def read_index(self, key: str, start: Union[int, None] = ..., stop: Union[int, None] = ...) -> Index: ...
    def write_index(self, key: str, index: Index): ...
    def write_multi_index(self, key: str, index: MultiIndex): ...
    def read_multi_index(self, key: str, start: Union[int, None] = ..., stop: Union[int, None] = ...) -> MultiIndex: ...
    def read_index_node(self, node: Node, start: Union[int, None] = ..., stop: Union[int, None] = ...) -> Index: ...
    def write_array_empty(self, key: str, value: ArrayLike): ...
    def write_array(self, key: str, obj: Union[DataFrame, Series], items: Union[Index, None] = ...) -> None: ...

class SeriesFixed(GenericFixed):
    pandas_kind: str
    attributes: Any
    name: Hashable
    @property
    def shape(self): ...
    def read(self, where: Any | None = ..., columns: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...): ...
    def write(self, obj, **kwargs) -> None: ...

class BlockManagerFixed(GenericFixed):
    attributes: Any
    nblocks: int
    @property
    def shape(self) -> Union[Shape, None]: ...
    def read(self, where: Any | None = ..., columns: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...): ...
    def write(self, obj, **kwargs) -> None: ...

class FrameFixed(BlockManagerFixed):
    pandas_kind: str
    obj_type: Any

class Table(Fixed):
    pandas_kind: str
    format_type: str
    table_type: str
    levels: Union[int, list[Hashable]]
    is_table: bool
    index_axes: list[IndexCol]
    non_index_axes: list[tuple[int, Any]]
    values_axes: list[DataCol]
    data_columns: list
    metadata: list
    info: dict
    nan_rep: Any
    def __init__(self, parent: HDFStore, group: Node, encoding: Any | None = ..., errors: str = ..., index_axes: Any | None = ..., non_index_axes: Any | None = ..., values_axes: Any | None = ..., data_columns: Any | None = ..., info: Any | None = ..., nan_rep: Any | None = ...) -> None: ...
    @property
    def table_type_short(self) -> str: ...
    def __getitem__(self, c: str): ...
    def validate(self, other) -> None: ...
    @property
    def is_multi_index(self) -> bool: ...
    def validate_multiindex(self, obj: Union[DataFrame, Series]) -> tuple[DataFrame, list[Hashable]]: ...
    @property
    def nrows_expected(self) -> int: ...
    @property
    def is_exists(self) -> bool: ...
    @property
    def storable(self): ...
    @property
    def table(self): ...
    @property
    def dtype(self): ...
    @property
    def description(self): ...
    @property
    def axes(self): ...
    @property
    def ncols(self) -> int: ...
    @property
    def is_transposed(self) -> bool: ...
    @property
    def data_orientation(self): ...
    def queryables(self) -> dict[str, Any]: ...
    def index_cols(self): ...
    def values_cols(self) -> list[str]: ...
    def write_metadata(self, key: str, values: np.ndarray): ...
    def read_metadata(self, key: str): ...
    def set_attrs(self) -> None: ...
    encoding: Any
    errors: Any
    def get_attrs(self) -> None: ...
    def validate_version(self, where: Any | None = ...) -> None: ...
    def validate_min_itemsize(self, min_itemsize) -> None: ...
    def indexables(self): ...
    def create_index(self, columns: Any | None = ..., optlevel: Any | None = ..., kind: Union[str, None] = ...): ...
    @classmethod
    def get_object(cls, obj, transposed: bool): ...
    def validate_data_columns(self, data_columns, min_itemsize, non_index_axes): ...
    def process_axes(self, obj, selection: Selection, columns: Any | None = ...): ...
    def create_description(self, complib, complevel: Union[int, None], fletcher32: bool, expectedrows: Union[int, None]) -> dict[str, Any]: ...
    def read_coordinates(self, where: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...): ...
    def read_column(self, column: str, where: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...): ...

class WORMTable(Table):
    table_type: str
    def read(self, where: Any | None = ..., columns: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...): ...
    def write(self, **kwargs) -> None: ...

class AppendableTable(Table):
    table_type: str
    def write(self, obj, axes: Any | None = ..., append: bool = ..., complib: Any | None = ..., complevel: Any | None = ..., fletcher32: Any | None = ..., min_itemsize: Any | None = ..., chunksize: Any | None = ..., expectedrows: Any | None = ..., dropna: bool = ..., nan_rep: Any | None = ..., data_columns: Any | None = ..., track_times: bool = ...) -> None: ...
    def write_data(self, chunksize: Union[int, None], dropna: bool = ...): ...
    def write_data_chunk(self, rows: np.ndarray, indexes: list[np.ndarray], mask: Union[np.ndarray, None], values: list[np.ndarray]): ...
    def delete(self, where: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...): ...

class AppendableFrameTable(AppendableTable):
    pandas_kind: str
    table_type: str
    ndim: int
    obj_type: type[Union[DataFrame, Series]]
    @property
    def is_transposed(self) -> bool: ...
    @classmethod
    def get_object(cls, obj, transposed: bool): ...
    def read(self, where: Any | None = ..., columns: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...): ...

class AppendableSeriesTable(AppendableFrameTable):
    pandas_kind: str
    table_type: str
    ndim: int
    obj_type: Any
    @property
    def is_transposed(self) -> bool: ...
    @classmethod
    def get_object(cls, obj, transposed: bool): ...
    def write(self, obj, data_columns: Any | None = ..., **kwargs): ...
    def read(self, where: Any | None = ..., columns: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...) -> Series: ...

class AppendableMultiSeriesTable(AppendableSeriesTable):
    pandas_kind: str
    table_type: str
    def write(self, obj, **kwargs): ...

class GenericTable(AppendableFrameTable):
    pandas_kind: str
    table_type: str
    ndim: int
    obj_type: Any
    levels: list[Hashable]
    @property
    def pandas_type(self) -> str: ...
    @property
    def storable(self): ...
    non_index_axes: Any
    nan_rep: Any
    index_axes: Any
    values_axes: Any
    data_columns: Any
    def get_attrs(self) -> None: ...
    def indexables(self): ...
    def write(self, **kwargs) -> None: ...

class AppendableMultiFrameTable(AppendableFrameTable):
    table_type: str
    obj_type: Any
    ndim: int
    @property
    def table_type_short(self) -> str: ...
    def write(self, obj, data_columns: Any | None = ..., **kwargs): ...
    def read(self, where: Any | None = ..., columns: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...): ...

class Selection:
    table: Any
    where: Any
    start: Any
    stop: Any
    condition: Any
    filter: Any
    terms: Any
    coordinates: Any
    def __init__(self, table: Table, where: Any | None = ..., start: Union[int, None] = ..., stop: Union[int, None] = ...) -> None: ...
    def generate(self, where): ...
    def select(self): ...
    def select_coords(self): ...
