import abc
from abc import ABC, abstractmethod
from pandas._config import get_option as get_option
from pandas._typing import Dtype as Dtype, WriteBuffer as WriteBuffer
from pandas.core.frame import DataFrame as DataFrame, Series as Series
from pandas.core.indexes.api import Index as Index
from pandas.io.formats.printing import pprint_thing as pprint_thing
from typing import Union, Any, Iterable, Mapping, Sequence

frame_max_cols_sub: Any
show_counts_sub: Any
null_counts_sub: Any
frame_examples_sub: Any
frame_see_also_sub: Any
frame_sub_kwargs: Any
series_examples_sub: Any
series_see_also_sub: Any
series_sub_kwargs: Any
INFO_DOCSTRING: Any

class BaseInfo(ABC, metaclass=abc.ABCMeta):
    data: Union[DataFrame, Series]
    memory_usage: Union[bool, str]
    @property
    @abstractmethod
    def dtypes(self) -> Iterable[Dtype]: ...
    @property
    @abstractmethod
    def dtype_counts(self) -> Mapping[str, int]: ...
    @property
    @abstractmethod
    def non_null_counts(self) -> Sequence[int]: ...
    @property
    @abstractmethod
    def memory_usage_bytes(self) -> int: ...
    @property
    def memory_usage_string(self) -> str: ...
    @property
    def size_qualifier(self) -> str: ...
    @abstractmethod
    def render(self, buf: Union[WriteBuffer[str], None], max_cols: Union[int, None], verbose: Union[bool, None], show_counts: Union[bool, None]) -> None: ...

class DataFrameInfo(BaseInfo):
    data: Any
    memory_usage: Any
    def __init__(self, data: DataFrame, memory_usage: Union[bool, str, None] = ...) -> None: ...
    @property
    def dtype_counts(self) -> Mapping[str, int]: ...
    @property
    def dtypes(self) -> Iterable[Dtype]: ...
    @property
    def ids(self) -> Index: ...
    @property
    def col_count(self) -> int: ...
    @property
    def non_null_counts(self) -> Sequence[int]: ...
    @property
    def memory_usage_bytes(self) -> int: ...
    def render(self, buf: Union[WriteBuffer[str], None], max_cols: Union[int, None], verbose: Union[bool, None], show_counts: Union[bool, None]) -> None: ...

class SeriesInfo(BaseInfo):
    data: Any
    memory_usage: Any
    def __init__(self, data: Series, memory_usage: Union[bool, str, None] = ...) -> None: ...
    def render(self, *, buf: Union[WriteBuffer[str], None] = ..., max_cols: Union[int, None] = ..., verbose: Union[bool, None] = ..., show_counts: Union[bool, None] = ...) -> None: ...
    @property
    def non_null_counts(self) -> Sequence[int]: ...
    @property
    def dtypes(self) -> Iterable[Dtype]: ...
    @property
    def dtype_counts(self): ...
    @property
    def memory_usage_bytes(self) -> int: ...

class InfoPrinterAbstract(metaclass=abc.ABCMeta):
    def to_buffer(self, buf: Union[WriteBuffer[str], None] = ...) -> None: ...

class DataFrameInfoPrinter(InfoPrinterAbstract):
    info: Any
    data: Any
    verbose: Any
    max_cols: Any
    show_counts: Any
    def __init__(self, info: DataFrameInfo, max_cols: Union[int, None] = ..., verbose: Union[bool, None] = ..., show_counts: Union[bool, None] = ...) -> None: ...
    @property
    def max_rows(self) -> int: ...
    @property
    def exceeds_info_cols(self) -> bool: ...
    @property
    def exceeds_info_rows(self) -> bool: ...
    @property
    def col_count(self) -> int: ...

class SeriesInfoPrinter(InfoPrinterAbstract):
    info: Any
    data: Any
    verbose: Any
    show_counts: Any
    def __init__(self, info: SeriesInfo, verbose: Union[bool, None] = ..., show_counts: Union[bool, None] = ...) -> None: ...

class TableBuilderAbstract(ABC, metaclass=abc.ABCMeta):
    info: BaseInfo
    @abstractmethod
    def get_lines(self) -> list[str]: ...
    @property
    def data(self) -> Union[DataFrame, Series]: ...
    @property
    def dtypes(self) -> Iterable[Dtype]: ...
    @property
    def dtype_counts(self) -> Mapping[str, int]: ...
    @property
    def display_memory_usage(self) -> bool: ...
    @property
    def memory_usage_string(self) -> str: ...
    @property
    def non_null_counts(self) -> Sequence[int]: ...
    def add_object_type_line(self) -> None: ...
    def add_index_range_line(self) -> None: ...
    def add_dtypes_line(self) -> None: ...

class DataFrameTableBuilder(TableBuilderAbstract, metaclass=abc.ABCMeta):
    info: Any
    def __init__(self, info: DataFrameInfo) -> None: ...
    def get_lines(self) -> list[str]: ...
    @property
    def data(self) -> DataFrame: ...
    @property
    def ids(self) -> Index: ...
    @property
    def col_count(self) -> int: ...
    def add_memory_usage_line(self) -> None: ...

class DataFrameTableBuilderNonVerbose(DataFrameTableBuilder):
    def add_columns_summary_line(self) -> None: ...

class TableBuilderVerboseMixin(TableBuilderAbstract, metaclass=abc.ABCMeta):
    SPACING: str
    strrows: Sequence[Sequence[str]]
    gross_column_widths: Sequence[int]
    with_counts: bool
    @property
    @abstractmethod
    def headers(self) -> Sequence[str]: ...
    @property
    def header_column_widths(self) -> Sequence[int]: ...
    def add_header_line(self) -> None: ...
    def add_separator_line(self) -> None: ...
    def add_body_lines(self) -> None: ...

class DataFrameTableBuilderVerbose(DataFrameTableBuilder, TableBuilderVerboseMixin):
    info: Any
    with_counts: Any
    strrows: Any
    gross_column_widths: Any
    def __init__(self, info: DataFrameInfo, with_counts: bool) -> None: ...
    @property
    def headers(self) -> Sequence[str]: ...
    def add_columns_summary_line(self) -> None: ...

class SeriesTableBuilder(TableBuilderAbstract, metaclass=abc.ABCMeta):
    info: Any
    def __init__(self, info: SeriesInfo) -> None: ...
    def get_lines(self) -> list[str]: ...
    @property
    def data(self) -> Series: ...
    def add_memory_usage_line(self) -> None: ...

class SeriesTableBuilderNonVerbose(SeriesTableBuilder): ...

class SeriesTableBuilderVerbose(SeriesTableBuilder, TableBuilderVerboseMixin):
    info: Any
    with_counts: Any
    strrows: Any
    gross_column_widths: Any
    def __init__(self, info: SeriesInfo, with_counts: bool) -> None: ...
    def add_series_name_line(self) -> None: ...
    @property
    def headers(self) -> Sequence[str]: ...
