from openpyxl.descriptors.serialisable import Serialisable as Serialisable
from pandas._typing import FilePath as FilePath, ReadBuffer as ReadBuffer, Scalar as Scalar, StorageOptions as StorageOptions
from pandas.compat._optional import import_optional_dependency as import_optional_dependency
from pandas.io.excel._base import BaseExcelReader as BaseExcelReader, ExcelWriter as ExcelWriter
from pandas.io.excel._util import combine_kwargs as combine_kwargs, validate_freeze_panes as validate_freeze_panes
from typing import Union, Any

class OpenpyxlWriter(ExcelWriter):
    engine: str
    supported_extensions: Any
    book: Any
    sheets: Any
    def __init__(self, path, engine: Any | None = ..., date_format: Any | None = ..., datetime_format: Any | None = ..., mode: str = ..., storage_options: StorageOptions = ..., if_sheet_exists: Union[str, None] = ..., engine_kwargs: Union[dict[str, Any], None] = ..., **kwargs) -> None: ...
    def save(self) -> None: ...
    def write_cells(self, cells, sheet_name: Any | None = ..., startrow: int = ..., startcol: int = ..., freeze_panes: Any | None = ...) -> None: ...

class OpenpyxlReader(BaseExcelReader):
    def __init__(self, filepath_or_buffer: Union[FilePath, ReadBuffer[bytes]], storage_options: StorageOptions = ...) -> None: ...
    def load_workbook(self, filepath_or_buffer: Union[FilePath, ReadBuffer[bytes]]): ...
    @property
    def sheet_names(self) -> list[str]: ...
    def get_sheet_by_name(self, name: str): ...
    def get_sheet_by_index(self, index: int): ...
    def get_sheet_data(self, sheet, convert_float: bool) -> list[list[Scalar]]: ...
