import zipfile
from collections import abc
from io import BytesIO, StringIO, TextIOBase
from pandas._typing import BaseBuffer as BaseBuffer, CompressionDict as CompressionDict, CompressionOptions as CompressionOptions, FilePath as FilePath, ReadBuffer as ReadBuffer, StorageOptions as StorageOptions, WriteBuffer as WriteBuffer
from pandas.compat import get_lzma_file as get_lzma_file
from pandas.compat._optional import import_optional_dependency as import_optional_dependency
from pandas.core.dtypes.common import is_file_like as is_file_like
from pandas.util._decorators import doc as doc
from pandas.util._exceptions import find_stack_level as find_stack_level
from pathlib import Path
from typing import Union, Any, AnyStr, IO, Literal, TypeVar, overload

BaseBufferT = TypeVar('BaseBufferT', bound=BaseBuffer)

class IOArgs:
    filepath_or_buffer: Union[str, BaseBuffer]
    encoding: str
    mode: str
    compression: CompressionDict
    should_close: bool

class IOHandles:
    handle: IO[AnyStr]
    compression: CompressionDict
    created_handles: list[Union[IO[bytes], IO[str]]]
    is_wrapped: bool
    is_mmap: bool
    def close(self) -> None: ...
    def __enter__(self) -> IOHandles[AnyStr]: ...
    def __exit__(self, *args: Any) -> None: ...

def is_url(url: object) -> bool: ...
def validate_header_arg(header: object) -> None: ...
@overload
def stringify_path(filepath_or_buffer: FilePath, convert_file_like: bool = ...) -> str: ...
@overload
def stringify_path(filepath_or_buffer: BaseBufferT, convert_file_like: bool = ...) -> BaseBufferT: ...
def urlopen(*args, **kwargs): ...
def is_fsspec_url(url: Union[FilePath, BaseBuffer]) -> bool: ...
def file_path_to_url(path: str) -> str: ...
def get_compression_method(compression: CompressionOptions) -> tuple[Union[str, None], CompressionDict]: ...
def infer_compression(filepath_or_buffer: Union[FilePath, BaseBuffer], compression: Union[str, None]) -> Union[str, None]: ...
def check_parent_directory(path: Union[Path, str]) -> None: ...
@overload
def get_handle(path_or_buf: Union[FilePath, BaseBuffer], mode: str, *, encoding: Union[str, None] = ..., compression: CompressionOptions = ..., memory_map: bool = ..., is_text: Literal[False], errors: Union[str, None] = ..., storage_options: StorageOptions = ...) -> IOHandles[bytes]: ...
@overload
def get_handle(path_or_buf: Union[FilePath, BaseBuffer], mode: str, *, encoding: Union[str, None] = ..., compression: CompressionOptions = ..., memory_map: bool = ..., is_text: Literal[True] = ..., errors: Union[str, None] = ..., storage_options: StorageOptions = ...) -> IOHandles[str]: ...

class _BytesZipFile(zipfile.ZipFile, BytesIO):
    archive_name: Any
    multiple_write_buffer: Any
    def __init__(self, file: Union[FilePath, ReadBuffer[bytes], WriteBuffer[bytes]], mode: str, archive_name: Union[str, None] = ..., **kwargs) -> None: ...
    def infer_filename(self): ...
    def write(self, data) -> None: ...
    def flush(self) -> None: ...
    def close(self) -> None: ...
    @property
    def closed(self): ...

class _MMapWrapper(abc.Iterator):
    encoding: Any
    errors: Any
    decoder: Any
    decode: Any
    attributes: Any
    mmap: Any
    def __init__(self, f: IO, encoding: str = ..., errors: str = ..., decode: bool = ...) -> None: ...
    def __getattr__(self, name: str): ...
    def __iter__(self) -> _MMapWrapper: ...
    def read(self, size: int = ...) -> Union[str, bytes]: ...
    def __next__(self) -> str: ...

class _IOWrapper:
    buffer: Any
    def __init__(self, buffer: BaseBuffer) -> None: ...
    def __getattr__(self, name: str): ...
    def readable(self) -> bool: ...
    def seekable(self) -> bool: ...
    def writable(self) -> bool: ...

class _BytesIOWrapper:
    buffer: Any
    encoding: Any
    overflow: bytes
    def __init__(self, buffer: Union[StringIO, TextIOBase], encoding: str = ...) -> None: ...
    def __getattr__(self, attr: str): ...
    def read(self, n: Union[int, None] = ...) -> bytes: ...

def file_exists(filepath_or_buffer: Union[FilePath, BaseBuffer]) -> bool: ...
