from pandas.core.frame import DataFrame as DataFrame, Series as Series
from pandas._libs.tslibs import BaseOffset as BaseOffset, to_offset as to_offset
from pandas._typing import ArrayLike as ArrayLike, Axis as Axis, NDFrameT as NDFrameT, WindowingRankType as WindowingRankType
from pandas.compat._optional import import_optional_dependency as import_optional_dependency
from pandas.core._numba import executor as executor
from pandas.core.algorithms import factorize as factorize
from pandas.core.apply import ResamplerWindowApply as ResamplerWindowApply
from pandas.core.arrays import ExtensionArray as ExtensionArray
from pandas.core.base import DataError as DataError, SelectionMixin as SelectionMixin
from pandas.core.dtypes.common import ensure_float64 as ensure_float64, is_bool as is_bool, is_integer as is_integer, is_list_like as is_list_like, is_scalar as is_scalar, needs_i8_conversion as needs_i8_conversion
from pandas.core.dtypes.generic import ABCDataFrame as ABCDataFrame, ABCSeries as ABCSeries
from pandas.core.dtypes.missing import notna as notna
from pandas.core.generic import NDFrame as NDFrame
from pandas.core.groupby.ops import BaseGrouper as BaseGrouper
from pandas.core.indexers.objects import BaseIndexer as BaseIndexer, FixedWindowIndexer as FixedWindowIndexer, GroupbyIndexer as GroupbyIndexer, VariableWindowIndexer as VariableWindowIndexer
from pandas.core.indexes.api import DatetimeIndex as DatetimeIndex, Index as Index, MultiIndex as MultiIndex, PeriodIndex as PeriodIndex, TimedeltaIndex as TimedeltaIndex
from pandas.core.internals import Block as Block
from pandas.core.reshape.concat import concat as concat
from pandas.core.util.numba_ import NUMBA_FUNC_CACHE as NUMBA_FUNC_CACHE, maybe_use_numba as maybe_use_numba
from pandas.core.window.common import flex_binary_moment as flex_binary_moment, zsqrt as zsqrt
from pandas.core.window.doc import args_compat as args_compat, create_section_header as create_section_header, kwargs_compat as kwargs_compat, kwargs_scipy as kwargs_scipy, numba_notes as numba_notes, template_header as template_header, template_returns as template_returns, template_see_also as template_see_also, window_agg_numba_parameters as window_agg_numba_parameters, window_apply_parameters as window_apply_parameters
from pandas.core.window.numba_ import generate_manual_numpy_nan_agg_with_axis as generate_manual_numpy_nan_agg_with_axis, generate_numba_apply_func as generate_numba_apply_func, generate_numba_table_func as generate_numba_table_func
from pandas.util._decorators import doc as doc
from pandas.util._exceptions import find_stack_level as find_stack_level
from typing import Union, Any, Callable, Hashable

class BaseWindow(SelectionMixin):
    exclusions: frozenset[Hashable]
    obj: Any
    on: Any
    closed: Any
    window: Any
    min_periods: Any
    center: Any
    axis: Any
    method: Any
    def __init__(self, obj: NDFrame, window: Any | None = ..., min_periods: Union[int, None] = ..., center: bool = ..., win_type: Union[str, None] = ..., axis: Axis = ..., on: Union[str, Index, None] = ..., closed: Union[str, None] = ..., method: str = ..., *, selection: Any | None = ...) -> None: ...
    @property
    def win_type(self): ...
    @property
    def is_datetimelike(self) -> bool: ...
    def validate(self) -> None: ...
    def __getattr__(self, attr: str): ...
    def __iter__(self): ...
    def aggregate(self, func, *args, **kwargs): ...
    agg: Any

class BaseWindowGroupby(BaseWindow):
    def __init__(self, obj: Union[DataFrame, Series], *args, _grouper: BaseGrouper, _as_index: bool = ..., **kwargs) -> None: ...

class Window(BaseWindow):
    def aggregate(self, func, *args, **kwargs): ...
    agg: Any
    def sum(self, *args, **kwargs): ...
    def mean(self, *args, **kwargs): ...
    def var(self, ddof: int = ..., *args, **kwargs): ...
    def std(self, ddof: int = ..., *args, **kwargs): ...

class RollingAndExpandingMixin(BaseWindow):
    def count(self): ...
    def apply(self, func: Callable[..., Any], raw: bool = ..., engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., args: Union[tuple[Any, ...], None] = ..., kwargs: Union[dict[str, Any], None] = ...): ...
    def sum(self, *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def max(self, *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def min(self, *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def mean(self, *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def median(self, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def std(self, ddof: int = ..., *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def var(self, ddof: int = ..., *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def skew(self, **kwargs): ...
    def sem(self, ddof: int = ..., *args, **kwargs): ...
    def kurt(self, **kwargs): ...
    def quantile(self, quantile: float, interpolation: str = ..., **kwargs): ...
    def rank(self, method: WindowingRankType = ..., ascending: bool = ..., pct: bool = ..., **kwargs): ...
    def cov(self, other: Union[DataFrame, Series, None] = ..., pairwise: Union[bool, None] = ..., ddof: int = ..., **kwargs): ...
    def corr(self, other: Union[DataFrame, Series, None] = ..., pairwise: Union[bool, None] = ..., ddof: int = ..., **kwargs): ...

class Rolling(RollingAndExpandingMixin):
    def aggregate(self, func, *args, **kwargs): ...
    agg: Any
    min_periods: int
    def count(self): ...
    def apply(self, func: Callable[..., Any], raw: bool = ..., engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., args: Union[tuple[Any, ...], None] = ..., kwargs: Union[dict[str, Any], None] = ...): ...
    def sum(self, *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def max(self, *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def min(self, *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def mean(self, *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def median(self, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def std(self, ddof: int = ..., *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def var(self, ddof: int = ..., *args, engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ..., **kwargs): ...
    def skew(self, **kwargs): ...
    def sem(self, ddof: int = ..., *args, **kwargs): ...
    def kurt(self, **kwargs): ...
    def quantile(self, quantile: float, interpolation: str = ..., **kwargs): ...
    def rank(self, method: WindowingRankType = ..., ascending: bool = ..., pct: bool = ..., **kwargs): ...
    def cov(self, other: Union[DataFrame, Series, None] = ..., pairwise: Union[bool, None] = ..., ddof: int = ..., **kwargs): ...
    def corr(self, other: Union[DataFrame, Series, None] = ..., pairwise: Union[bool, None] = ..., ddof: int = ..., **kwargs): ...

class RollingGroupby(BaseWindowGroupby, Rolling): ...
