import numpy as np
from pandas._libs import lib
from pandas._typing import AggFuncType, ArrayLike, Axis, Dtype, DtypeObj, FillnaOptions, IndexKeyFunc, NumpySorter, NumpyValueArrayLike, StorageOptions, TimedeltaConvertibleTypes, TimestampConvertibleTypes, ValueKeyFunc, npt
from pandas.core import base
from pandas.core.arrays import ExtensionArray
from pandas.core.frame import DataFrame
from pandas.core.generic import NDFrame
from pandas.core.groupby.generic import SeriesGroupBy
from pandas.core.indexes.api import Index
from pandas.core.resample import Resampler
from typing import Union, Any, Callable, Hashable, IO, Iterable, Literal, Sequence, overload

class Series(base.IndexOpsMixin, NDFrame):
    hasnans: Any
    div: Callable[[Series, Any], Series]
    rdiv: Callable[[Series, Any], Series]
    def __init__(self, data: Any | None = ..., index: Any | None = ..., dtype: Union[Dtype, None] = ..., name: Any | None = ..., copy: bool = ..., fastpath: bool = ...) -> None: ...
    @property
    def dtype(self) -> DtypeObj: ...
    @property
    def dtypes(self) -> DtypeObj: ...
    @property
    def name(self) -> Hashable: ...
    @name.setter
    def name(self, value: Hashable) -> None: ...
    @property
    def values(self): ...
    @property
    def array(self) -> ExtensionArray: ...
    def ravel(self, order: str = ...): ...
    def __len__(self) -> int: ...
    def view(self, dtype: Union[Dtype, None] = ...) -> Series: ...
    def __array__(self, dtype: Union[npt.DTypeLike, None] = ...) -> np.ndarray: ...
    __float__: Any
    __long__: Any
    __int__: Any
    @property
    def axes(self) -> list[Index]: ...
    def take(self, indices, axis: int = ..., is_copy: Any | None = ..., **kwargs) -> Series: ...
    def __getitem__(self, key): ...
    def __setitem__(self, key, value) -> None: ...
    def repeat(self, repeats, axis: Any | None = ...) -> Series: ...
    index: Any
    def reset_index(self, level: Any | None = ..., drop: bool = ..., name=..., inplace: bool = ...): ...
    def to_string(self, buf: Any | None = ..., na_rep: str = ..., float_format: Any | None = ..., header: bool = ..., index: bool = ..., length: bool = ..., dtype: bool = ..., name: bool = ..., max_rows: Any | None = ..., min_rows: Any | None = ...): ...
    def to_markdown(self, buf: Union[IO[str], None] = ..., mode: str = ..., index: bool = ..., storage_options: StorageOptions = ..., **kwargs) -> Union[str, None]: ...
    def items(self) -> Iterable[tuple[Hashable, Any]]: ...
    def iteritems(self) -> Iterable[tuple[Hashable, Any]]: ...
    def keys(self) -> Index: ...
    def to_dict(self, into=...): ...
    def to_frame(self, name: Hashable = ...) -> DataFrame: ...
    def groupby(self, by: Any | None = ..., axis: int = ..., level: Any | None = ..., as_index: bool = ..., sort: bool = ..., group_keys: bool = ..., squeeze: Union[bool, lib.NoDefault] = ..., observed: bool = ..., dropna: bool = ...) -> SeriesGroupBy: ...
    def count(self, level: Any | None = ...): ...
    def mode(self, dropna: bool = ...) -> Series: ...
    def unique(self) -> ArrayLike: ...
    @overload
    def drop_duplicates(self, keep=..., inplace: Literal[False] = ...) -> Series: ...
    @overload
    def drop_duplicates(self, keep, inplace: Literal[True]) -> None: ...
    @overload
    def drop_duplicates(self, inplace: Literal[True]) -> None: ...
    @overload
    def drop_duplicates(self, keep=..., inplace: bool = ...) -> Union[Series, None]: ...
    def duplicated(self, keep: str = ...) -> Series: ...
    def idxmin(self, axis: int = ..., skipna: bool = ..., *args, **kwargs): ...
    def idxmax(self, axis: int = ..., skipna: bool = ..., *args, **kwargs): ...
    def round(self, decimals: int = ..., *args, **kwargs) -> Series: ...
    def quantile(self, q: float = ..., interpolation: str = ...): ...
    def corr(self, other, method: str = ..., min_periods: Any | None = ...) -> float: ...
    def cov(self, other: Series, min_periods: Union[int, None] = ..., ddof: Union[int, None] = ...) -> float: ...
    def diff(self, periods: int = ...) -> Series: ...
    def autocorr(self, lag: int = ...) -> float: ...
    def dot(self, other): ...
    def __matmul__(self, other): ...
    def __rmatmul__(self, other): ...
    def searchsorted(self, value: Union[NumpyValueArrayLike, ExtensionArray], side: Literal[left, right] = ..., sorter: NumpySorter = ...) -> Union[npt.NDArray[np.intp], np.intp]: ...
    def append(self, to_append, ignore_index: bool = ..., verify_integrity: bool = ...): ...
    def compare(self, other: Series, align_axis: Axis = ..., keep_shape: bool = ..., keep_equal: bool = ...) -> Union[DataFrame, Series]: ...
    def combine(self, other, func, fill_value: Any | None = ...) -> Series: ...
    def combine_first(self, other) -> Series: ...
    def update(self, other) -> None: ...
    def sort_values(self, axis: int = ..., ascending: Union[bool, int, Sequence[Union[bool, int]]] = ..., inplace: bool = ..., kind: str = ..., na_position: str = ..., ignore_index: bool = ..., key: ValueKeyFunc = ...): ...
    def sort_index(self, axis: int = ..., level: Any | None = ..., ascending: Union[bool, int, Sequence[Union[bool, int]]] = ..., inplace: bool = ..., kind: str = ..., na_position: str = ..., sort_remaining: bool = ..., ignore_index: bool = ..., key: IndexKeyFunc = ...): ...
    def argsort(self, axis: int = ..., kind: str = ..., order: Any | None = ...) -> Series: ...
    def nlargest(self, n: int = ..., keep: str = ...) -> Series: ...
    def nsmallest(self, n: int = ..., keep: str = ...) -> Series: ...
    def swaplevel(self, i: int = ..., j: int = ..., copy: bool = ...) -> Series: ...
    def reorder_levels(self, order) -> Series: ...
    def explode(self, ignore_index: bool = ...) -> Series: ...
    def unstack(self, level: int = ..., fill_value: Any | None = ...) -> DataFrame: ...
    def map(self, arg, na_action: Any | None = ...) -> Series: ...
    def aggregate(self, func: Any | None = ..., axis: int = ..., *args, **kwargs): ...
    agg: Any
    def transform(self, func: AggFuncType, axis: Axis = ..., *args, **kwargs) -> Union[DataFrame, Series]: ...
    def apply(self, func: AggFuncType, convert_dtype: bool = ..., args: tuple[Any, ...] = ..., **kwargs) -> Union[DataFrame, Series]: ...
    def align(self, other, join: str = ..., axis: Any | None = ..., level: Any | None = ..., copy: bool = ..., fill_value: Any | None = ..., method: Any | None = ..., limit: Any | None = ..., fill_axis: int = ..., broadcast_axis: Any | None = ...): ...
    def rename(self, index: Any | None = ..., *, axis: Any | None = ..., copy: bool = ..., inplace: bool = ..., level: Any | None = ..., errors: str = ...) -> Union[Series, None]: ...
    @overload
    def set_axis(self, labels, axis: Axis = ..., inplace: Literal[False] = ...) -> Series: ...
    @overload
    def set_axis(self, labels, axis: Axis, inplace: Literal[True]) -> None: ...
    @overload
    def set_axis(self, labels, inplace: Literal[True]) -> None: ...
    @overload
    def set_axis(self, labels, axis: Axis = ..., inplace: bool = ...) -> Union[Series, None]: ...
    def reindex(self, *args, **kwargs) -> Series: ...
    def drop(self, labels: Any | None = ..., axis: int = ..., index: Any | None = ..., columns: Any | None = ..., level: Any | None = ..., inplace: bool = ..., errors: str = ...) -> Series: ...
    @overload
    def fillna(self, value=..., method: Union[FillnaOptions, None] = ..., axis: Union[Axis, None] = ..., inplace: Literal[False] = ..., limit=..., downcast=...) -> Series: ...
    @overload
    def fillna(self, value, method: Union[FillnaOptions, None], axis: Union[Axis, None], inplace: Literal[True], limit=..., downcast=...) -> None: ...
    @overload
    def fillna(self, inplace: Literal[True], *, limit=..., downcast=...) -> None: ...
    @overload
    def fillna(self, value, inplace: Literal[True], *, limit=..., downcast=...) -> None: ...
    @overload
    def fillna(self, method: Union[FillnaOptions, None], inplace: Literal[True], *, limit=..., downcast=...) -> None: ...
    @overload
    def fillna(self, axis: Union[Axis, None], inplace: Literal[True], *, limit=..., downcast=...) -> None: ...
    @overload
    def fillna(self, method: Union[FillnaOptions, None], axis: Union[Axis, None], inplace: Literal[True], *, limit=..., downcast=...) -> None: ...
    @overload
    def fillna(self, value, axis: Union[Axis, None], inplace: Literal[True], *, limit=..., downcast=...) -> None: ...
    @overload
    def fillna(self, value, method: Union[FillnaOptions, None], inplace: Literal[True], *, limit=..., downcast=...) -> None: ...
    @overload
    def fillna(self, value=..., method: Union[FillnaOptions, None] = ..., axis: Union[Axis, None] = ..., inplace: bool = ..., limit=..., downcast=...) -> Union[Series, None]: ...
    def pop(self, item: Hashable) -> Any: ...
    def replace(self, to_replace: Any | None = ..., value=..., inplace: bool = ..., limit: Any | None = ..., regex: bool = ..., method: Union[str, lib.NoDefault] = ...): ...
    def info(self, verbose: Union[bool, None] = ..., buf: Union[IO[str], None] = ..., max_cols: Union[int, None] = ..., memory_usage: Union[bool, str, None] = ..., show_counts: bool = ...) -> None: ...
    def shift(self, periods: int = ..., freq: Any | None = ..., axis: int = ..., fill_value: Any | None = ...) -> Series: ...
    def memory_usage(self, index: bool = ..., deep: bool = ...) -> int: ...
    def isin(self, values) -> Series: ...
    def between(self, left, right, inclusive: str = ...) -> Series: ...
    def isna(self) -> Series: ...
    def isnull(self) -> Series: ...
    def notna(self) -> Series: ...
    def notnull(self) -> Series: ...
    def dropna(self, axis: int = ..., inplace: bool = ..., how: Any | None = ...): ...
    def asfreq(self, freq, method: Any | None = ..., how: Union[str, None] = ..., normalize: bool = ..., fill_value: Any | None = ...) -> Series: ...
    def resample(self, rule, axis: int = ..., closed: Union[str, None] = ..., label: Union[str, None] = ..., convention: str = ..., kind: Union[str, None] = ..., loffset: Any | None = ..., base: Union[int, None] = ..., on: Any | None = ..., level: Any | None = ..., origin: Union[str, TimestampConvertibleTypes] = ..., offset: Union[TimedeltaConvertibleTypes, None] = ...) -> Resampler: ...
    def to_timestamp(self, freq: Any | None = ..., how: str = ..., copy: bool = ...) -> Series: ...
    def to_period(self, freq: Any | None = ..., copy: bool = ...) -> Series: ...
    def ffill(self, axis: Union[None, Axis] = ..., inplace: bool = ..., limit: Union[None, int] = ..., downcast: Any | None = ...) -> Union[Series, None]: ...
    def bfill(self, axis: Union[None, Axis] = ..., inplace: bool = ..., limit: Union[None, int] = ..., downcast: Any | None = ...) -> Union[Series, None]: ...
    def clip(self, lower: Any | None = ..., upper: Any | None = ..., axis: Union[Axis, None] = ..., inplace: bool = ..., *args, **kwargs) -> Union[Series, None]: ...
    def interpolate(self, method: str = ..., axis: Axis = ..., limit: Union[int, None] = ..., inplace: bool = ..., limit_direction: Union[str, None] = ..., limit_area: Union[str, None] = ..., downcast: Union[str, None] = ..., **kwargs) -> Union[Series, None]: ...
    def where(self, cond, other=..., inplace: bool = ..., axis: Any | None = ..., level: Any | None = ..., errors=..., try_cast=...): ...
    def mask(self, cond, other=..., inplace: bool = ..., axis: Any | None = ..., level: Any | None = ..., errors=..., try_cast=...): ...
    str: Any
    dt: Any
    cat: Any
    plot: Any
    sparse: Any
    hist: Any
