from pandas.core.frame import DataFrame as DataFrame, Series as Series
from pandas._libs import lib as lib
from pandas._libs.tslibs import BaseOffset as BaseOffset, IncompatibleFrequency as IncompatibleFrequency, NaT as NaT, Period as Period, Timedelta as Timedelta, Timestamp as Timestamp, to_offset as to_offset
from pandas._typing import IndexLabel as IndexLabel, NDFrameT as NDFrameT, T as T, TimedeltaConvertibleTypes as TimedeltaConvertibleTypes, TimestampConvertibleTypes as TimestampConvertibleTypes, npt as npt
from pandas.core.apply import ResamplerWindowApply as ResamplerWindowApply
from pandas.core.base import DataError as DataError, PandasObject as PandasObject
from pandas.core.dtypes.generic import ABCDataFrame as ABCDataFrame, ABCSeries as ABCSeries
from pandas.core.generic import NDFrame as NDFrame
from pandas.core.groupby.generic import SeriesGroupBy as SeriesGroupBy
from pandas.core.groupby.groupby import BaseGroupBy as BaseGroupBy, GroupBy as GroupBy, get_groupby as get_groupby
from pandas.core.groupby.grouper import Grouper as Grouper
from pandas.core.groupby.ops import BinGrouper as BinGrouper
from pandas.core.indexes.api import Index as Index
from pandas.core.indexes.datetimes import DatetimeIndex as DatetimeIndex, date_range as date_range
from pandas.core.indexes.period import PeriodIndex as PeriodIndex, period_range as period_range
from pandas.core.indexes.timedeltas import TimedeltaIndex as TimedeltaIndex, timedelta_range as timedelta_range
from pandas.errors import AbstractMethodError as AbstractMethodError
from pandas.tseries.frequencies import is_subperiod as is_subperiod, is_superperiod as is_superperiod
from pandas.tseries.offsets import DateOffset as DateOffset, Day as Day, Nano as Nano, Tick as Tick
from pandas.util._decorators import Appender as Appender, Substitution as Substitution, deprecate_nonkeyword_arguments as deprecate_nonkeyword_arguments, doc as doc
from pandas.util._exceptions import find_stack_level as find_stack_level
from typing import Union, Any, Callable, Hashable, Literal

class Resampler(BaseGroupBy, PandasObject):
    grouper: BinGrouper
    exclusions: frozenset[Hashable]
    groupby: Any
    keys: Any
    sort: bool
    axis: Any
    kind: Any
    squeeze: bool
    group_keys: bool
    as_index: bool
    def __init__(self, obj: Union[DataFrame, Series], groupby: TimeGrouper, axis: int = ..., kind: Any | None = ..., *, selection: Any | None = ..., **kwargs) -> None: ...
    def __getattr__(self, attr: str): ...
    @property
    def obj(self) -> NDFrameT: ...
    @property
    def ax(self): ...
    def pipe(self, func: Union[Callable[..., T], tuple[Callable[..., T], str]], *args, **kwargs) -> T: ...
    def aggregate(self, func: Any | None = ..., *args, **kwargs): ...
    agg: Any
    apply: Any
    def transform(self, arg, *args, **kwargs): ...
    def ffill(self, limit: Any | None = ...): ...
    def pad(self, limit: Any | None = ...): ...
    def nearest(self, limit: Any | None = ...): ...
    def bfill(self, limit: Any | None = ...): ...
    def backfill(self, limit: Any | None = ...): ...
    def fillna(self, method, limit: Any | None = ...): ...
    def interpolate(self, method: str = ..., axis: int = ..., limit: Any | None = ..., inplace: bool = ..., limit_direction: str = ..., limit_area: Any | None = ..., downcast: Any | None = ..., **kwargs): ...
    def asfreq(self, fill_value: Any | None = ...): ...
    def std(self, ddof: int = ..., *args, **kwargs): ...
    def var(self, ddof: int = ..., *args, **kwargs): ...
    def size(self): ...
    def count(self): ...
    def quantile(self, q: float = ..., **kwargs): ...

def f(self, _method=..., min_count: int = ..., *args, **kwargs): ...
def g(self, _method=..., *args, **kwargs): ...
def h(self, _method=...): ...

class _GroupByMixin(PandasObject):
    binner: Any
    groupby: Any
    def __init__(self, obj, parent: Any | None = ..., groupby: Any | None = ..., **kwargs) -> None: ...

class DatetimeIndexResampler(Resampler): ...
class DatetimeIndexResamplerGroupby(_GroupByMixin, DatetimeIndexResampler): ...
class PeriodIndexResampler(DatetimeIndexResampler): ...
class PeriodIndexResamplerGroupby(_GroupByMixin, PeriodIndexResampler): ...
class TimedeltaIndexResampler(DatetimeIndexResampler): ...
class TimedeltaIndexResamplerGroupby(_GroupByMixin, TimedeltaIndexResampler): ...

def get_resampler(obj, kind: Any | None = ..., **kwds): ...
def get_resampler_for_grouping(groupby, rule, how: Any | None = ..., fill_method: Any | None = ..., limit: Any | None = ..., kind: Any | None = ..., on: Any | None = ..., **kwargs): ...

class TimeGrouper(Grouper):
    closed: Any
    label: Any
    kind: Any
    convention: Any
    how: Any
    fill_method: Any
    limit: Any
    origin: Any
    offset: Any
    loffset: Any
    def __init__(self, freq: str = ..., closed: Union[Literal[left, right], None] = ..., label: Union[str, None] = ..., how: str = ..., axis: int = ..., fill_method: Any | None = ..., limit: Any | None = ..., loffset: Any | None = ..., kind: Union[str, None] = ..., convention: Union[str, None] = ..., base: Union[int, None] = ..., origin: Union[str, TimestampConvertibleTypes] = ..., offset: Union[TimedeltaConvertibleTypes, None] = ..., **kwargs) -> None: ...

def asfreq(obj: NDFrameT, freq, method: Any | None = ..., how: Any | None = ..., normalize: bool = ..., fill_value: Any | None = ...) -> NDFrameT: ...
