from pandas._typing import ArrayLike as ArrayLike, DtypeObj as DtypeObj, Shape as Shape
from pandas.core.base import PandasObject as PandasObject
from pandas.core.dtypes.cast import find_common_type as find_common_type
from pandas.core.indexes.api import Index as Index, default_index as default_index
from pandas.errors import AbstractMethodError as AbstractMethodError
from typing import Union, Any, TypeVar

T = TypeVar('T', bound='DataManager')

class DataManager(PandasObject):
    axes: list[Index]
    @property
    def items(self) -> Index: ...
    def __len__(self) -> int: ...
    @property
    def ndim(self) -> int: ...
    @property
    def shape(self) -> Shape: ...
    def reindex_indexer(self, new_axis, indexer, axis: int, fill_value: Any | None = ..., allow_dups: bool = ..., copy: bool = ..., consolidate: bool = ..., only_slice: bool = ...) -> T: ...
    def reindex_axis(self, new_index: Index, axis: int, fill_value: Any | None = ..., consolidate: bool = ..., only_slice: bool = ...) -> T: ...
    def equals(self, other: object) -> bool: ...
    def apply(self, f, align_keys: Union[list[str], None] = ..., ignore_failures: bool = ..., **kwargs) -> T: ...
    def isna(self, func) -> T: ...
    def is_consolidated(self) -> bool: ...
    def consolidate(self) -> T: ...

class SingleDataManager(DataManager):
    ndim: int
    @property
    def array(self) -> ArrayLike: ...
    def setitem_inplace(self, indexer, value) -> None: ...
    def grouped_reduce(self, func, ignore_failures: bool = ...): ...
    @classmethod
    def from_array(cls, arr: ArrayLike, index: Index): ...

def interleaved_dtype(dtypes: list[DtypeObj]) -> Union[DtypeObj, None]: ...
