import numpy as np
from pandas._libs import lib as lib
from pandas._libs.tslibs import BaseOffset as BaseOffset, NaT as NaT, Period as Period, Resolution as Resolution, Tick as Tick
from pandas._typing import Dtype as Dtype, DtypeObj as DtypeObj
from pandas.core.arrays.period import PeriodArray as PeriodArray, period_array as period_array, raise_on_incompatible as raise_on_incompatible, validate_dtype_freq as validate_dtype_freq
from pandas.core.dtypes.common import is_datetime64_any_dtype as is_datetime64_any_dtype, is_integer as is_integer, pandas_dtype as pandas_dtype
from pandas.core.dtypes.dtypes import PeriodDtype as PeriodDtype
from pandas.core.dtypes.missing import is_valid_na_for_dtype as is_valid_na_for_dtype
from pandas.core.indexes.base import maybe_extract_name as maybe_extract_name
from pandas.core.indexes.datetimelike import DatetimeIndexOpsMixin as DatetimeIndexOpsMixin
from pandas.core.indexes.datetimes import DatetimeIndex as DatetimeIndex, Index as Index
from pandas.core.indexes.extension import inherit_names as inherit_names
from pandas.core.indexes.numeric import Int64Index as Int64Index
from pandas.util._decorators import doc as doc
from pandas.util._exceptions import find_stack_level as find_stack_level
from typing import Union, Any, Hashable

class PeriodIndex(DatetimeIndexOpsMixin):
    freq: BaseOffset
    dtype: PeriodDtype
    def asfreq(self, freq: Any | None = ..., how: str = ...) -> PeriodIndex: ...
    def to_timestamp(self, freq: Any | None = ..., how: str = ...) -> DatetimeIndex: ...
    @property
    def hour(self) -> Int64Index: ...
    @property
    def minute(self) -> Int64Index: ...
    @property
    def second(self) -> Int64Index: ...
    def __new__(cls, data: Any | None = ..., ordinal: Any | None = ..., freq: Any | None = ..., dtype: Union[Dtype, None] = ..., copy: bool = ..., name: Hashable = ..., **fields) -> PeriodIndex: ...
    @property
    def values(self) -> np.ndarray: ...
    def asof_locs(self, where: Index, mask: np.ndarray) -> np.ndarray: ...
    def astype(self, dtype, copy: bool = ..., how=...): ...
    @property
    def is_full(self) -> bool: ...
    @property
    def inferred_type(self) -> str: ...
    def get_loc(self, key, method: Any | None = ..., tolerance: Any | None = ...): ...

def period_range(start: Any | None = ..., end: Any | None = ..., periods: Union[int, None] = ..., freq: Any | None = ..., name: Any | None = ...) -> PeriodIndex: ...
