import numpy as np
from datetime import tzinfo
from pandas import DataFrame as DataFrame, Float64Index as Float64Index, PeriodIndex as PeriodIndex, TimedeltaIndex as TimedeltaIndex
from pandas._libs import NaT as NaT, Period as Period, Timestamp as Timestamp, lib as lib
from pandas._libs.tslibs import Resolution as Resolution, timezones as timezones, to_offset as to_offset
from pandas._libs.tslibs.offsets import prefix_mapping as prefix_mapping
from pandas._typing import Dtype as Dtype, DtypeObj as DtypeObj, npt as npt
from pandas.core.arrays.datetimes import DatetimeArray as DatetimeArray, tz_to_dtype as tz_to_dtype
from pandas.core.dtypes.common import DT64NS_DTYPE as DT64NS_DTYPE, is_datetime64_dtype as is_datetime64_dtype, is_datetime64tz_dtype as is_datetime64tz_dtype, is_scalar as is_scalar
from pandas.core.dtypes.missing import is_valid_na_for_dtype as is_valid_na_for_dtype
from pandas.core.indexes.base import Index as Index, get_unanimous_names as get_unanimous_names, maybe_extract_name as maybe_extract_name
from pandas.core.indexes.datetimelike import DatetimeTimedeltaMixin as DatetimeTimedeltaMixin
from pandas.core.indexes.extension import inherit_names as inherit_names
from pandas.core.tools.times import to_time as to_time
from pandas.util._decorators import cache_readonly as cache_readonly, doc as doc
from pandas.util._exceptions import find_stack_level as find_stack_level
from typing import Union, Any, Hashable, Literal

class DatetimeIndex(DatetimeTimedeltaMixin):
    inferred_freq: Union[str, None]
    tz: Union[tzinfo, None]
    def strftime(self, date_format) -> Index: ...
    def tz_convert(self, tz) -> DatetimeIndex: ...
    def tz_localize(self, tz, ambiguous: str = ..., nonexistent: str = ...) -> DatetimeIndex: ...
    def to_period(self, freq: Any | None = ...) -> PeriodIndex: ...
    def to_perioddelta(self, freq) -> TimedeltaIndex: ...
    def to_julian_date(self) -> Float64Index: ...
    def isocalendar(self) -> DataFrame: ...
    def __new__(cls, data: Any | None = ..., freq=..., tz: Any | None = ..., normalize: bool = ..., closed: Any | None = ..., ambiguous: str = ..., dayfirst: bool = ..., yearfirst: bool = ..., dtype: Union[Dtype, None] = ..., copy: bool = ..., name: Hashable = ...) -> DatetimeIndex: ...
    def __reduce__(self): ...
    def union_many(self, others): ...
    def to_series(self, keep_tz=..., index: Any | None = ..., name: Any | None = ...): ...
    def snap(self, freq: str = ...) -> DatetimeIndex: ...
    def get_loc(self, key, method: Any | None = ..., tolerance: Any | None = ...): ...
    def slice_indexer(self, start: Any | None = ..., end: Any | None = ..., step: Any | None = ..., kind=...): ...
    def get_slice_bound(self, label, side: Literal[left, right], kind=...) -> int: ...
    @property
    def inferred_type(self) -> str: ...
    def indexer_at_time(self, time, asof: bool = ...) -> npt.NDArray[np.intp]: ...
    def indexer_between_time(self, start_time, end_time, include_start: bool = ..., include_end: bool = ...) -> npt.NDArray[np.intp]: ...

def date_range(start: Any | None = ..., end: Any | None = ..., periods: Any | None = ..., freq: Any | None = ..., tz: Any | None = ..., normalize: bool = ..., name: Hashable = ..., closed: Union[str, None, lib.NoDefault] = ..., inclusive: Union[str, None] = ..., **kwargs) -> DatetimeIndex: ...
def bdate_range(start: Any | None = ..., end: Any | None = ..., periods: Union[int, None] = ..., freq: str = ..., tz: Any | None = ..., normalize: bool = ..., name: Hashable = ..., weekmask: Any | None = ..., holidays: Any | None = ..., closed: lib.NoDefault = ..., inclusive: Union[str, None] = ..., **kwargs) -> DatetimeIndex: ...
