import numpy as np
from pandas._config.config import option_context as option_context
from pandas._libs import Timestamp as Timestamp, lib as lib
from pandas._typing import ArrayLike as ArrayLike, IndexLabel as IndexLabel, NDFrameT as NDFrameT, PositionalIndexer as PositionalIndexer, RandomState as RandomState, Scalar as Scalar, T as T, npt as npt
from pandas.core import nanops as nanops
from pandas.core._numba import executor as executor
from pandas.core.arrays import BaseMaskedArray as BaseMaskedArray, BooleanArray as BooleanArray, Categorical as Categorical, ExtensionArray as ExtensionArray
from pandas.core.base import DataError as DataError, PandasObject as PandasObject, SelectionMixin as SelectionMixin
from pandas.core.dtypes.common import is_bool_dtype as is_bool_dtype, is_datetime64_dtype as is_datetime64_dtype, is_float_dtype as is_float_dtype, is_integer as is_integer, is_integer_dtype as is_integer_dtype, is_numeric_dtype as is_numeric_dtype, is_object_dtype as is_object_dtype, is_scalar as is_scalar, is_timedelta64_dtype as is_timedelta64_dtype
from pandas.core.dtypes.missing import isna as isna, notna as notna
from pandas.core.frame import DataFrame as DataFrame
from pandas.core.generic import NDFrame as NDFrame
from pandas.core.groupby import base as base, numba_ as numba_, ops as ops
from pandas.core.groupby.indexing import GroupByIndexingMixin as GroupByIndexingMixin, GroupByNthSelector as GroupByNthSelector
from pandas.core.indexes.api import CategoricalIndex as CategoricalIndex, Index as Index, MultiIndex as MultiIndex
from pandas.core.internals.blocks import ensure_block_shape as ensure_block_shape
from pandas.core.series import Series as Series
from pandas.core.sorting import get_group_index_sorter as get_group_index_sorter
from pandas.core.util.numba_ import NUMBA_FUNC_CACHE as NUMBA_FUNC_CACHE, maybe_use_numba as maybe_use_numba
from pandas.errors import AbstractMethodError as AbstractMethodError
from pandas.util._decorators import Appender as Appender, Substitution as Substitution, cache_readonly as cache_readonly, doc as doc
from pandas.util._exceptions import find_stack_level as find_stack_level
from typing import Union, Any, Callable, Hashable, Iterator, Literal, Sequence, TypeVar

class GroupByPlot(PandasObject):
    def __init__(self, groupby: GroupBy) -> None: ...
    def __call__(self, *args, **kwargs): ...
    def __getattr__(self, name: str): ...

class BaseGroupBy(PandasObject, SelectionMixin[NDFrameT], GroupByIndexingMixin):
    axis: int
    grouper: ops.BaseGrouper
    group_keys: bool
    def __len__(self) -> int: ...
    @property
    def groups(self) -> dict[Hashable, np.ndarray]: ...
    @property
    def ngroups(self) -> int: ...
    @property
    def indices(self): ...
    def pipe(self, func: Union[Callable[..., T], tuple[Callable[..., T], str]], *args, **kwargs) -> T: ...
    plot: Any
    def get_group(self, name, obj: Any | None = ...) -> Union[DataFrame, Series]: ...
    def __iter__(self) -> Iterator[tuple[Hashable, NDFrameT]]: ...
OutputFrameOrSeries = TypeVar('OutputFrameOrSeries', bound=NDFrame)

class GroupBy(BaseGroupBy[NDFrameT]):
    grouper: ops.BaseGrouper
    as_index: bool
    level: Any
    keys: Any
    sort: Any
    group_keys: Any
    squeeze: Any
    observed: Any
    mutated: Any
    dropna: Any
    obj: Any
    axis: Any
    exclusions: Any
    def __init__(self, obj: NDFrameT, keys: Union[_KeysArgType, None] = ..., axis: int = ..., level: Union[IndexLabel, None] = ..., grouper: Union[ops.BaseGrouper, None] = ..., exclusions: Union[frozenset[Hashable], None] = ..., selection: Union[IndexLabel, None] = ..., as_index: bool = ..., sort: bool = ..., group_keys: bool = ..., squeeze: bool = ..., observed: bool = ..., mutated: bool = ..., dropna: bool = ...) -> None: ...
    def __getattr__(self, attr: str): ...
    def __getattribute__(self, attr: str): ...
    def apply(self, func, *args, **kwargs): ...
    def any(self, skipna: bool = ...): ...
    def all(self, skipna: bool = ...): ...
    def count(self) -> Union[Series, DataFrame]: ...
    def mean(self, numeric_only: Union[bool, lib.NoDefault] = ..., engine: str = ..., engine_kwargs: Union[dict[str, bool], None] = ...): ...
    def median(self, numeric_only: Union[bool, lib.NoDefault] = ...): ...
    def std(self, ddof: int = ..., engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ...): ...
    def var(self, ddof: int = ..., engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ...): ...
    def sem(self, ddof: int = ...): ...
    def size(self) -> Union[DataFrame, Series]: ...
    def sum(self, numeric_only: Union[bool, lib.NoDefault] = ..., min_count: int = ..., engine: Union[str, None] = ..., engine_kwargs: Union[dict[str, bool], None] = ...) -> Union[DataFrame, Series]: ...
    def prod(self, numeric_only: Union[bool, lib.NoDefault] = ..., min_count: int = ...): ...
    def min(self, numeric_only: bool = ..., min_count: int = ...): ...
    def max(self, numeric_only: bool = ..., min_count: int = ...): ...
    def first(self, numeric_only: bool = ..., min_count: int = ...): ...
    def last(self, numeric_only: bool = ..., min_count: int = ...): ...
    def ohlc(self) -> DataFrame: ...
    def describe(self, **kwargs): ...
    def resample(self, rule, *args, **kwargs): ...
    def rolling(self, *args, **kwargs): ...
    def expanding(self, *args, **kwargs): ...
    def ewm(self, *args, **kwargs): ...
    def ffill(self, limit: Any | None = ...): ...
    def pad(self, limit: Any | None = ...): ...
    def bfill(self, limit: Any | None = ...): ...
    def backfill(self, limit: Any | None = ...): ...
    def nth(self, n: Union[PositionalIndexer, tuple], dropna: Literal[any, all, None] = ...) -> NDFrameT: ...
    def quantile(self, q: float = ..., interpolation: str = ...): ...
    def ngroup(self, ascending: bool = ...): ...
    def cumcount(self, ascending: bool = ...): ...
    def rank(self, method: str = ..., ascending: bool = ..., na_option: str = ..., pct: bool = ..., axis: int = ...): ...
    def cumprod(self, axis: int = ..., *args, **kwargs): ...
    def cumsum(self, axis: int = ..., *args, **kwargs): ...
    def cummin(self, axis: int = ..., **kwargs): ...
    def cummax(self, axis: int = ..., **kwargs): ...
    def shift(self, periods: int = ..., freq: Any | None = ..., axis: int = ..., fill_value: Any | None = ...): ...
    def pct_change(self, periods: int = ..., fill_method: str = ..., limit: Any | None = ..., freq: Any | None = ..., axis: int = ...): ...
    def head(self, n: int = ...): ...
    def tail(self, n: int = ...): ...
    def sample(self, n: Union[int, None] = ..., frac: Union[float, None] = ..., replace: bool = ..., weights: Union[Sequence, Series, None] = ..., random_state: Union[RandomState, None] = ...): ...

def get_groupby(obj: NDFrame, by: Union[_KeysArgType, None] = ..., axis: int = ..., level: Any | None = ..., grouper: Union[ops.BaseGrouper, None] = ..., exclusions: Any | None = ..., selection: Any | None = ..., as_index: bool = ..., sort: bool = ..., group_keys: bool = ..., squeeze: bool = ..., observed: bool = ..., mutated: bool = ..., dropna: bool = ...) -> GroupBy: ...
def warn_dropping_nuisance_columns_deprecated(cls, how: str) -> None: ...
