import numpy as np
import pyarrow
from datetime import tzinfo
from pandas import Categorical as Categorical, Index as Index
from pandas._libs.interval import Interval as Interval
from pandas._libs.properties import cache_readonly as cache_readonly
from pandas._libs.tslibs import BaseOffset as BaseOffset, NaT as NaT, Period as Period, Timestamp as Timestamp, dtypes as dtypes, timezones as timezones, to_offset as to_offset, tz_compare as tz_compare
from pandas._typing import Dtype as Dtype, DtypeObj as DtypeObj, Ordered as Ordered, npt as npt, type_t as type_t
from pandas.core.arrays import DatetimeArray as DatetimeArray, IntervalArray as IntervalArray, PandasArray as PandasArray, PeriodArray as PeriodArray
from pandas.core.dtypes.base import ExtensionDtype as ExtensionDtype, register_extension_dtype as register_extension_dtype
from pandas.core.dtypes.generic import ABCCategoricalIndex as ABCCategoricalIndex, ABCIndex as ABCIndex
from pandas.core.dtypes.inference import is_bool as is_bool, is_list_like as is_list_like
from typing import Union, Any

str_type = str

class PandasExtensionDtype(ExtensionDtype):
    type: Any
    kind: Any
    subdtype: Any
    str: str_type
    num: int
    shape: tuple[int, ...]
    itemsize: int
    base: Union[DtypeObj, None]
    isbuiltin: int
    isnative: int
    def __hash__(self) -> int: ...
    @classmethod
    def reset_cache(cls) -> None: ...

class CategoricalDtypeType(type): ...

class CategoricalDtype(PandasExtensionDtype, ExtensionDtype):
    name: str
    type: type[CategoricalDtypeType]
    kind: str_type
    str: str
    base: Any
    def __init__(self, categories: Any | None = ..., ordered: Ordered = ...) -> None: ...
    @classmethod
    def construct_from_string(cls, string: str_type) -> CategoricalDtype: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: Any) -> bool: ...
    @classmethod
    def construct_array_type(cls) -> type_t[Categorical]: ...
    @staticmethod
    def validate_ordered(ordered: Ordered) -> None: ...
    @staticmethod
    def validate_categories(categories, fastpath: bool = ...) -> Index: ...
    def update_dtype(self, dtype: Union[str_type, CategoricalDtype]) -> CategoricalDtype: ...
    @property
    def categories(self) -> Index: ...
    @property
    def ordered(self) -> Ordered: ...

class DatetimeTZDtype(PandasExtensionDtype):
    type: type[Timestamp]
    kind: str_type
    str: str
    num: int
    base: Any
    na_value: Any
    def __init__(self, unit: Union[str_type, DatetimeTZDtype] = ..., tz: Any | None = ...) -> None: ...
    @property
    def unit(self) -> str_type: ...
    @property
    def tz(self) -> tzinfo: ...
    @classmethod
    def construct_array_type(cls) -> type_t[DatetimeArray]: ...
    @classmethod
    def construct_from_string(cls, string: str_type) -> DatetimeTZDtype: ...
    @property
    def name(self) -> str_type: ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: Any) -> bool: ...

class PeriodDtype(dtypes.PeriodDtypeBase, PandasExtensionDtype):
    type: type[Period]
    kind: str_type
    str: str
    base: Any
    num: int
    def __new__(cls, freq: Any | None = ...): ...
    def __reduce__(self): ...
    @property
    def freq(self): ...
    @classmethod
    def construct_from_string(cls, string: str_type) -> PeriodDtype: ...
    @property
    def name(self) -> str_type: ...
    @property
    def na_value(self): ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    @classmethod
    def is_dtype(cls, dtype: object) -> bool: ...
    @classmethod
    def construct_array_type(cls) -> type_t[PeriodArray]: ...
    def __from_arrow__(self, array: Union[pyarrow.Array, pyarrow.ChunkedArray]) -> PeriodArray: ...

class IntervalDtype(PandasExtensionDtype):
    name: str
    kind: str_type
    str: str
    base: Any
    num: int
    def __new__(cls, subtype: Any | None = ..., closed: Union[str_type, None] = ...): ...
    @property
    def closed(self): ...
    @property
    def subtype(self): ...
    @classmethod
    def construct_array_type(cls) -> type[IntervalArray]: ...
    @classmethod
    def construct_from_string(cls, string: str_type) -> IntervalDtype: ...
    @property
    def type(self): ...
    def __hash__(self) -> int: ...
    def __eq__(self, other: Any) -> bool: ...
    @classmethod
    def is_dtype(cls, dtype: object) -> bool: ...
    def __from_arrow__(self, array: Union[pyarrow.Array, pyarrow.ChunkedArray]) -> IntervalArray: ...

class PandasDtype(ExtensionDtype):
    def __init__(self, dtype: Union[npt.DTypeLike, PandasDtype, None]) -> None: ...
    @property
    def numpy_dtype(self) -> np.dtype: ...
    @property
    def name(self) -> str: ...
    @property
    def type(self) -> type[np.generic]: ...
    @classmethod
    def construct_from_string(cls, string: str) -> PandasDtype: ...
    @classmethod
    def construct_array_type(cls) -> type_t[PandasArray]: ...
    @property
    def kind(self) -> str: ...
    @property
    def itemsize(self) -> int: ...
