import abc
import numpy as np
from abc import ABC, abstractmethod
from pandas.core.frame import DataFrame as DataFrame, Series as Series
from pandas._libs.tslibs import Timestamp as Timestamp
from pandas._typing import NDFrameT as NDFrameT
from pandas.core.dtypes.common import is_bool_dtype as is_bool_dtype, is_datetime64_any_dtype as is_datetime64_any_dtype, is_numeric_dtype as is_numeric_dtype, is_timedelta64_dtype as is_timedelta64_dtype
from pandas.core.reshape.concat import concat as concat
from pandas.io.formats.format import format_percentiles as format_percentiles
from pandas.util._exceptions import find_stack_level as find_stack_level
from pandas.util._validators import validate_percentile as validate_percentile
from typing import Union, Any, Callable, Hashable, Sequence

def describe_ndframe(obj: NDFrameT, include: Union[str, Sequence[str], None], exclude: Union[str, Sequence[str], None], datetime_is_numeric: bool, percentiles: Union[Sequence[float], np.ndarray, None]) -> NDFrameT: ...

class NDFrameDescriberAbstract(ABC, metaclass=abc.ABCMeta):
    obj: Any
    datetime_is_numeric: Any
    def __init__(self, obj: Union[DataFrame, Series], datetime_is_numeric: bool) -> None: ...
    @abstractmethod
    def describe(self, percentiles: Union[Sequence[float], np.ndarray]) -> Union[DataFrame, Series]: ...

class SeriesDescriber(NDFrameDescriberAbstract):
    obj: Series
    def describe(self, percentiles: Union[Sequence[float], np.ndarray]) -> Series: ...

class DataFrameDescriber(NDFrameDescriberAbstract):
    include: Any
    exclude: Any
    def __init__(self, obj: DataFrame, include: Union[str, Sequence[str], None], exclude: Union[str, Sequence[str], None], datetime_is_numeric: bool) -> None: ...
    def describe(self, percentiles: Union[Sequence[float], np.ndarray]) -> DataFrame: ...

def reorder_columns(ldesc: Sequence[Series]) -> list[Hashable]: ...
def describe_numeric_1d(series: Series, percentiles: Sequence[float]) -> Series: ...
def describe_categorical_1d(data: Series, percentiles_ignored: Sequence[float]) -> Series: ...
def describe_timestamp_as_categorical_1d(data: Series, percentiles_ignored: Sequence[float]) -> Series: ...
def describe_timestamp_1d(data: Series, percentiles: Sequence[float]) -> Series: ...
def select_describe_func(data: Series, datetime_is_numeric: bool) -> Callable: ...
def refine_percentiles(percentiles: Union[Sequence[float], np.ndarray, None]) -> np.ndarray[Any, np.dtype[np.float64]]: ...
