from pandas._libs.tslibs import Timedelta as Timedelta, Timestamp as Timestamp
from pandas._typing import npt as npt
from pandas.compat.chainmap import DeepChainMap as DeepChainMap
from pandas.core.computation import expr as expr, ops as ops, scope as _scope
from pandas.core.computation.common import ensure_decoded as ensure_decoded
from pandas.core.computation.expr import BaseExprVisitor as BaseExprVisitor
from pandas.core.computation.ops import UndefinedVariableError as UndefinedVariableError, is_term as is_term
from pandas.core.construction import extract_array as extract_array
from pandas.core.dtypes.common import is_list_like as is_list_like
from pandas.core.indexes.base import Index as Index
from pandas.io.formats.printing import pprint_thing as pprint_thing, pprint_thing_encoded as pprint_thing_encoded
from typing import Union, Any

class PyTablesScope(_scope.Scope):
    queryables: dict[str, Any]
    def __init__(self, level: int, global_dict: Any | None = ..., local_dict: Any | None = ..., queryables: Union[dict[str, Any], None] = ...) -> None: ...

class Term(ops.Term):
    env: PyTablesScope
    def __new__(cls, name, env, side: Any | None = ..., encoding: Any | None = ...): ...
    def __init__(self, name, env: PyTablesScope, side: Any | None = ..., encoding: Any | None = ...) -> None: ...
    @property
    def value(self): ...

class Constant(Term):
    def __init__(self, value, env: PyTablesScope, side: Any | None = ..., encoding: Any | None = ...) -> None: ...

class BinOp(ops.BinOp):
    op: str
    queryables: dict[str, Any]
    condition: Union[str, None]
    encoding: Any
    def __init__(self, op: str, lhs, rhs, queryables: dict[str, Any], encoding) -> None: ...
    def prune(self, klass): ...
    def conform(self, rhs): ...
    @property
    def is_valid(self) -> bool: ...
    @property
    def is_in_table(self) -> bool: ...
    @property
    def kind(self): ...
    @property
    def meta(self): ...
    @property
    def metadata(self): ...
    def generate(self, v) -> str: ...
    def convert_value(self, v) -> TermValue: ...
    def convert_values(self) -> None: ...

class FilterBinOp(BinOp):
    filter: Union[tuple[Any, Any, Index], None]
    def invert(self): ...
    def format(self): ...
    def evaluate(self): ...
    def generate_filter_op(self, invert: bool = ...): ...

class JointFilterBinOp(FilterBinOp):
    def format(self) -> None: ...
    def evaluate(self): ...

class ConditionBinOp(BinOp):
    def invert(self) -> None: ...
    def format(self): ...
    condition: Any
    def evaluate(self): ...

class JointConditionBinOp(ConditionBinOp):
    condition: Any
    def evaluate(self): ...

class UnaryOp(ops.UnaryOp):
    def prune(self, klass): ...

class PyTablesExprVisitor(BaseExprVisitor):
    const_type: Any
    term_type: Any
    def __init__(self, env, engine, parser, **kwargs): ...
    def visit_UnaryOp(self, node, **kwargs): ...
    def visit_Index(self, node, **kwargs): ...
    def visit_Assign(self, node, **kwargs): ...
    def visit_Subscript(self, node, **kwargs): ...
    def visit_Attribute(self, node, **kwargs): ...
    def translate_In(self, op): ...

class PyTablesExpr(expr.Expr):
    env: PyTablesScope
    expr: str
    encoding: Any
    condition: Any
    filter: Any
    terms: Any
    def __init__(self, where, queryables: Union[dict[str, Any], None] = ..., encoding: Any | None = ..., scope_level: int = ...) -> None: ...
    def evaluate(self): ...

class TermValue:
    value: Any
    converted: Any
    kind: Any
    def __init__(self, value, converted, kind: str) -> None: ...
    def tostring(self, encoding) -> str: ...

def maybe_expression(s) -> bool: ...
