import numpy as np
from pandas._libs.tslibs import Timestamp as Timestamp
from pandas.core.computation.common import ensure_decoded as ensure_decoded, result_type_many as result_type_many
from pandas.core.computation.scope import DEFAULT_GLOBALS as DEFAULT_GLOBALS
from pandas.core.dtypes.common import is_list_like as is_list_like, is_scalar as is_scalar
from pandas.io.formats.printing import pprint_thing as pprint_thing, pprint_thing_encoded as pprint_thing_encoded
from typing import Union, Any, Iterable

REDUCTIONS: Any
MATHOPS: Any
LOCAL_TAG: str

class UndefinedVariableError(NameError):
    def __init__(self, name: str, is_local: Union[bool, None] = ...) -> None: ...

class Term:
    def __new__(cls, name, env, side: Any | None = ..., encoding: Any | None = ...): ...
    is_local: bool
    env: Any
    side: Any
    encoding: Any
    def __init__(self, name, env, side: Any | None = ..., encoding: Any | None = ...) -> None: ...
    @property
    def local_name(self) -> str: ...
    def __call__(self, *args, **kwargs): ...
    def evaluate(self, *args, **kwargs): ...
    def update(self, value) -> None: ...
    @property
    def is_scalar(self) -> bool: ...
    @property
    def type(self): ...
    return_type: Any
    @property
    def raw(self) -> str: ...
    @property
    def is_datetime(self) -> bool: ...
    @property
    def value(self): ...
    @value.setter
    def value(self, new_value) -> None: ...
    @property
    def name(self): ...
    @property
    def ndim(self) -> int: ...

class Constant(Term):
    def __init__(self, value, env, side: Any | None = ..., encoding: Any | None = ...) -> None: ...
    @property
    def name(self): ...

class Op:
    op: str
    operands: Any
    encoding: Any
    def __init__(self, op: str, operands: Iterable[Union[Term, Op]], encoding: Any | None = ...) -> None: ...
    def __iter__(self): ...
    @property
    def return_type(self): ...
    @property
    def has_invalid_return_type(self) -> bool: ...
    @property
    def operand_types(self): ...
    @property
    def is_scalar(self) -> bool: ...
    @property
    def is_datetime(self) -> bool: ...

CMP_OPS_SYMS: Any
BOOL_OPS_SYMS: Any
ARITH_OPS_SYMS: Any
SPECIAL_CASE_ARITH_OPS_SYMS: Any

def is_term(obj) -> bool: ...

class BinOp(Op):
    lhs: Any
    rhs: Any
    func: Any
    def __init__(self, op: str, lhs, rhs) -> None: ...
    def __call__(self, env): ...
    def evaluate(self, env, engine: str, parser, term_type, eval_in_python): ...
    def convert_values(self): ...

def isnumeric(dtype) -> bool: ...

class Div(BinOp):
    def __init__(self, lhs, rhs) -> None: ...

UNARY_OPS_SYMS: Any

class UnaryOp(Op):
    operand: Any
    func: Any
    def __init__(self, op: str, operand) -> None: ...
    def __call__(self, env): ...
    @property
    def return_type(self) -> np.dtype: ...

class MathCall(Op):
    func: Any
    def __init__(self, func, args) -> None: ...
    def __call__(self, env): ...

class FuncNode:
    name: Any
    func: Any
    def __init__(self, name: str) -> None: ...
    def __call__(self, *args): ...
