import numpy as np
from pandas import Categorical as Categorical
from pandas._typing import ArrayLike as ArrayLike, DtypeObj as DtypeObj, IndexLabel as IndexLabel, NDFrameT as NDFrameT, NumpySorter as NumpySorter, NumpyValueArrayLike as NumpyValueArrayLike, Shape as Shape, npt as npt
from pandas.compat import PYPY as PYPY
from pandas.core import algorithms as algorithms, nanops as nanops, ops as ops
from pandas.core.accessor import DirNamesMixin as DirNamesMixin
from pandas.core.algorithms import duplicated as duplicated, unique1d as unique1d, value_counts as value_counts
from pandas.core.arraylike import OpsMixin as OpsMixin
from pandas.core.arrays import ExtensionArray as ExtensionArray
from pandas.core.construction import create_series_with_explicit_dtype as create_series_with_explicit_dtype, ensure_wrapped_if_datetimelike as ensure_wrapped_if_datetimelike, extract_array as extract_array
from pandas.core.dtypes.common import is_categorical_dtype as is_categorical_dtype, is_dict_like as is_dict_like, is_extension_array_dtype as is_extension_array_dtype, is_object_dtype as is_object_dtype, is_scalar as is_scalar
from pandas.core.dtypes.generic import ABCDataFrame as ABCDataFrame, ABCIndex as ABCIndex, ABCSeries as ABCSeries
from pandas.core.dtypes.missing import isna as isna, remove_na_arraylike as remove_na_arraylike
from pandas.errors import AbstractMethodError as AbstractMethodError
from pandas.util._decorators import cache_readonly as cache_readonly, doc as doc
from typing import Union, Any, Hashable, Literal, overload

class PandasObject(DirNamesMixin):
    def __sizeof__(self) -> int: ...

class NoNewAttributesMixin:
    def __setattr__(self, key: str, value): ...

class DataError(Exception): ...
class SpecificationError(Exception): ...

class SelectionMixin:
    obj: NDFrameT
    exclusions: frozenset[Hashable]
    def ndim(self) -> int: ...
    def __getitem__(self, key): ...
    def aggregate(self, func, *args, **kwargs) -> None: ...
    agg: Any

class IndexOpsMixin(OpsMixin):
    __array_priority__: int
    @property
    def dtype(self) -> DtypeObj: ...
    def transpose(self, *args, **kwargs) -> _T: ...
    T: Any
    @property
    def shape(self) -> Shape: ...
    def __len__(self) -> int: ...
    @property
    def ndim(self) -> int: ...
    def item(self): ...
    @property
    def nbytes(self) -> int: ...
    @property
    def size(self) -> int: ...
    @property
    def array(self) -> ExtensionArray: ...
    def to_numpy(self, dtype: Union[npt.DTypeLike, None] = ..., copy: bool = ..., na_value=..., **kwargs) -> np.ndarray: ...
    @property
    def empty(self) -> bool: ...
    def max(self, axis: Any | None = ..., skipna: bool = ..., *args, **kwargs): ...
    def argmax(self, axis: Any | None = ..., skipna: bool = ..., *args, **kwargs) -> int: ...
    def min(self, axis: Any | None = ..., skipna: bool = ..., *args, **kwargs): ...
    def argmin(self, axis: Any | None = ..., skipna: bool = ..., *args, **kwargs) -> int: ...
    def tolist(self): ...
    to_list: Any
    def __iter__(self): ...
    def hasnans(self) -> bool: ...
    def isna(self): ...
    def value_counts(self, normalize: bool = ..., sort: bool = ..., ascending: bool = ..., bins: Any | None = ..., dropna: bool = ...): ...
    def unique(self): ...
    def nunique(self, dropna: bool = ...) -> int: ...
    @property
    def is_unique(self) -> bool: ...
    @property
    def is_monotonic(self) -> bool: ...
    @property
    def is_monotonic_increasing(self) -> bool: ...
    @property
    def is_monotonic_decreasing(self) -> bool: ...
    def factorize(self, sort: bool = ..., na_sentinel: Union[int, None] = ...): ...
    @overload
    def searchsorted(self, value: npt._ScalarLike_co, side: Literal[left, right] = ..., sorter: NumpySorter = ...) -> np.intp: ...
    @overload
    def searchsorted(self, value: Union[npt.ArrayLike, ExtensionArray], side: Literal[left, right] = ..., sorter: NumpySorter = ...) -> npt.NDArray[np.intp]: ...
    def drop_duplicates(self, keep: str = ...): ...
