import numpy as np
from enum import Enum
from pandas import Series as Series
from pandas._libs import lib as lib
from pandas._libs.sparse import BlockIndex as BlockIndex, IntIndex as IntIndex, SparseIndex as SparseIndex
from pandas._libs.tslibs import NaT as NaT
from pandas._typing import ArrayLike as ArrayLike, AstypeArg as AstypeArg, Dtype as Dtype, FillnaOptions as FillnaOptions, NpDtype as NpDtype, NumpySorter as NumpySorter, PositionalIndexer as PositionalIndexer, Scalar as Scalar, ScalarIndexer as ScalarIndexer, SequenceIndexer as SequenceIndexer, npt as npt
from pandas.core import arraylike as arraylike
from pandas.core.arraylike import OpsMixin as OpsMixin
from pandas.core.arrays import ExtensionArray as ExtensionArray
from pandas.core.arrays.sparse.dtype import SparseDtype as SparseDtype
from pandas.core.base import PandasObject as PandasObject
from pandas.core.construction import extract_array as extract_array, sanitize_array as sanitize_array
from pandas.core.dtypes.cast import astype_nansafe as astype_nansafe, construct_1d_arraylike_from_scalar as construct_1d_arraylike_from_scalar, find_common_type as find_common_type, maybe_box_datetimelike as maybe_box_datetimelike
from pandas.core.dtypes.common import is_array_like as is_array_like, is_bool_dtype as is_bool_dtype, is_datetime64_any_dtype as is_datetime64_any_dtype, is_datetime64tz_dtype as is_datetime64tz_dtype, is_dtype_equal as is_dtype_equal, is_integer as is_integer, is_list_like as is_list_like, is_object_dtype as is_object_dtype, is_scalar as is_scalar, is_string_dtype as is_string_dtype, pandas_dtype as pandas_dtype
from pandas.core.dtypes.generic import ABCIndex as ABCIndex, ABCSeries as ABCSeries
from pandas.core.dtypes.missing import isna as isna, na_value_for_dtype as na_value_for_dtype, notna as notna
from pandas.core.indexers import check_array_indexer as check_array_indexer, unpack_tuple_and_ellipses as unpack_tuple_and_ellipses
from pandas.core.missing import interpolate_2d as interpolate_2d
from pandas.core.nanops import check_below_min_count as check_below_min_count
from pandas.errors import PerformanceWarning as PerformanceWarning
from pandas.util._exceptions import find_stack_level as find_stack_level
from pandas.util._validators import validate_insert_loc as validate_insert_loc
from scipy.sparse import spmatrix as spmatrix
from typing import Union, Any, Literal, TypeVar, overload

class ellipsis(Enum):
    Ellipsis: str

Ellipsis: Any
SparseIndexKind: Any
SparseArrayT = TypeVar('SparseArrayT', bound='SparseArray')

class SparseArray(OpsMixin, PandasObject, ExtensionArray):
    def __init__(self, data, sparse_index: Any | None = ..., index: Any | None = ..., fill_value: Any | None = ..., kind: SparseIndexKind = ..., dtype: Union[Dtype, None] = ..., copy: bool = ...) -> None: ...
    @classmethod
    def from_spmatrix(cls, data: spmatrix) -> SparseArrayT: ...
    def __array__(self, dtype: Union[NpDtype, None] = ...) -> np.ndarray: ...
    def __setitem__(self, key, value) -> None: ...
    @property
    def sp_index(self) -> SparseIndex: ...
    @property
    def sp_values(self) -> np.ndarray: ...
    @property
    def dtype(self) -> SparseDtype: ...
    @property
    def fill_value(self): ...
    @fill_value.setter
    def fill_value(self, value) -> None: ...
    @property
    def kind(self) -> SparseIndexKind: ...
    def __len__(self) -> int: ...
    @property
    def nbytes(self) -> int: ...
    @property
    def density(self) -> float: ...
    @property
    def npoints(self) -> int: ...
    def isna(self): ...
    def fillna(self, value: Any | None = ..., method: Union[FillnaOptions, None] = ..., limit: Union[int, None] = ...) -> SparseArrayT: ...
    def shift(self, periods: int = ..., fill_value: Any | None = ...) -> SparseArrayT: ...
    def unique(self) -> SparseArrayT: ...
    def factorize(self, na_sentinel: int = ...) -> tuple[np.ndarray, SparseArray]: ...
    def value_counts(self, dropna: bool = ...) -> Series: ...
    @overload
    def __getitem__(self, key: ScalarIndexer) -> Any: ...
    @overload
    def __getitem__(self, key: Union[SequenceIndexer, tuple[Union[int, ellipsis], ...]]) -> SparseArrayT: ...
    def take(self, indices, *, allow_fill: bool = ..., fill_value: Any | None = ...) -> SparseArrayT: ...
    def searchsorted(self, v: Union[ArrayLike, object], side: Literal[left, right] = ..., sorter: NumpySorter = ...) -> Union[npt.NDArray[np.intp], np.intp]: ...
    def copy(self) -> SparseArrayT: ...
    def astype(self, dtype: Union[AstypeArg, None] = ..., copy: bool = ...): ...
    def map(self, mapper) -> SparseArrayT: ...
    def to_dense(self) -> np.ndarray: ...
    def nonzero(self): ...
    def all(self, axis: Any | None = ..., *args, **kwargs): ...
    def any(self, axis: int = ..., *args, **kwargs): ...
    def sum(self, axis: int = ..., min_count: int = ..., skipna: bool = ..., *args, **kwargs) -> Scalar: ...
    def cumsum(self, axis: int = ..., *args, **kwargs) -> SparseArray: ...
    def mean(self, axis: int = ..., *args, **kwargs): ...
    def max(self, *, axis: Union[int, None] = ..., skipna: bool = ...): ...
    def min(self, *, axis: Union[int, None] = ..., skipna: bool = ...): ...
    def __array_ufunc__(self, ufunc: np.ufunc, method: str, *inputs, **kwargs): ...
    def __pos__(self) -> SparseArray: ...
    def __neg__(self) -> SparseArray: ...
    def __invert__(self) -> SparseArray: ...
    def __abs__(self) -> SparseArray: ...

def make_sparse(arr: np.ndarray, kind: SparseIndexKind = ..., fill_value: Any | None = ..., dtype: Union[NpDtype, None] = ...): ...
@overload
def make_sparse_index(length: int, indices, kind: Literal[block]) -> BlockIndex: ...
@overload
def make_sparse_index(length: int, indices, kind: Literal[integer]) -> IntIndex: ...
