import numpy as np
from pandas._libs import lib as lib
from pandas._typing import Dtype as Dtype, NpDtype as NpDtype, Scalar as Scalar, npt as npt
from pandas.core import arraylike as arraylike, nanops as nanops, ops as ops
from pandas.core.arraylike import OpsMixin as OpsMixin
from pandas.core.arrays._mixins import NDArrayBackedExtensionArray as NDArrayBackedExtensionArray
from pandas.core.construction import ensure_wrapped_if_datetimelike as ensure_wrapped_if_datetimelike
from pandas.core.dtypes.cast import construct_1d_object_array_from_listlike as construct_1d_object_array_from_listlike
from pandas.core.dtypes.dtypes import PandasDtype as PandasDtype
from pandas.core.dtypes.missing import isna as isna
from pandas.core.strings.object_array import ObjectStringArrayMixin as ObjectStringArrayMixin
from typing import Union, Any

class PandasArray(OpsMixin, NDArrayBackedExtensionArray, ObjectStringArrayMixin):
    __array_priority__: int
    def __init__(self, values: Union[np.ndarray, PandasArray], copy: bool = ...) -> None: ...
    @property
    def dtype(self) -> PandasDtype: ...
    def __array__(self, dtype: Union[NpDtype, None] = ...) -> np.ndarray: ...
    def __array_ufunc__(self, ufunc: np.ufunc, method: str, *inputs, **kwargs): ...
    def isna(self) -> np.ndarray: ...
    def any(self, *, axis: Union[int, None] = ..., out: Any | None = ..., keepdims: bool = ..., skipna: bool = ...): ...
    def all(self, *, axis: Union[int, None] = ..., out: Any | None = ..., keepdims: bool = ..., skipna: bool = ...): ...
    def min(self, *, axis: Union[int, None] = ..., skipna: bool = ..., **kwargs) -> Scalar: ...
    def max(self, *, axis: Union[int, None] = ..., skipna: bool = ..., **kwargs) -> Scalar: ...
    def sum(self, *, axis: Union[int, None] = ..., skipna: bool = ..., min_count: int = ..., **kwargs) -> Scalar: ...
    def prod(self, *, axis: Union[int, None] = ..., skipna: bool = ..., min_count: int = ..., **kwargs) -> Scalar: ...
    def mean(self, *, axis: Union[int, None] = ..., dtype: Union[NpDtype, None] = ..., out: Any | None = ..., keepdims: bool = ..., skipna: bool = ...): ...
    def median(self, *, axis: Union[int, None] = ..., out: Any | None = ..., overwrite_input: bool = ..., keepdims: bool = ..., skipna: bool = ...): ...
    def std(self, *, axis: Union[int, None] = ..., dtype: Union[NpDtype, None] = ..., out: Any | None = ..., ddof: int = ..., keepdims: bool = ..., skipna: bool = ...): ...
    def var(self, *, axis: Union[int, None] = ..., dtype: Union[NpDtype, None] = ..., out: Any | None = ..., ddof: int = ..., keepdims: bool = ..., skipna: bool = ...): ...
    def sem(self, *, axis: Union[int, None] = ..., dtype: Union[NpDtype, None] = ..., out: Any | None = ..., ddof: int = ..., keepdims: bool = ..., skipna: bool = ...): ...
    def kurt(self, *, axis: Union[int, None] = ..., dtype: Union[NpDtype, None] = ..., out: Any | None = ..., keepdims: bool = ..., skipna: bool = ...): ...
    def skew(self, *, axis: Union[int, None] = ..., dtype: Union[NpDtype, None] = ..., out: Any | None = ..., keepdims: bool = ..., skipna: bool = ...): ...
    def to_numpy(self, dtype: Union[npt.DTypeLike, None] = ..., copy: bool = ..., na_value=...) -> np.ndarray: ...
    def __invert__(self) -> PandasArray: ...
    def __neg__(self) -> PandasArray: ...
    def __pos__(self) -> PandasArray: ...
    def __abs__(self) -> PandasArray: ...
