import numpy as np
from pandas import Series as Series
from pandas._libs import iNaT as iNaT, lib as lib
from pandas._typing import ArrayLike as ArrayLike, AstypeArg as AstypeArg, NpDtype as NpDtype, PositionalIndexer as PositionalIndexer, Scalar as Scalar, ScalarIndexer as ScalarIndexer, SequenceIndexer as SequenceIndexer, Shape as Shape, npt as npt, type_t as type_t
from pandas.core import arraylike as arraylike, missing as missing, nanops as nanops, ops as ops
from pandas.core.algorithms import factorize_array as factorize_array, isin as isin, take as take
from pandas.core.array_algos import masked_reductions as masked_reductions
from pandas.core.array_algos.quantile import quantile_with_mask as quantile_with_mask
from pandas.core.arraylike import OpsMixin as OpsMixin
from pandas.core.arrays import BooleanArray as BooleanArray, ExtensionArray as ExtensionArray
from pandas.core.dtypes.base import ExtensionDtype as ExtensionDtype
from pandas.core.dtypes.common import is_bool as is_bool, is_bool_dtype as is_bool_dtype, is_dtype_equal as is_dtype_equal, is_float as is_float, is_float_dtype as is_float_dtype, is_integer_dtype as is_integer_dtype, is_list_like as is_list_like, is_numeric_dtype as is_numeric_dtype, is_object_dtype as is_object_dtype, is_scalar as is_scalar, is_string_dtype as is_string_dtype, pandas_dtype as pandas_dtype
from pandas.core.dtypes.inference import is_array_like as is_array_like
from pandas.core.dtypes.missing import array_equivalent as array_equivalent, isna as isna, notna as notna
from pandas.core.indexers import check_array_indexer as check_array_indexer
from pandas.core.ops import invalid_comparison as invalid_comparison
from pandas.errors import AbstractMethodError as AbstractMethodError
from pandas.util._decorators import cache_readonly as cache_readonly, doc as doc
from pandas.util._validators import validate_fillna_kwargs as validate_fillna_kwargs
from typing import Union, Any, TypeVar, overload

BaseMaskedArrayT = TypeVar('BaseMaskedArrayT', bound='BaseMaskedArray')

class BaseMaskedDtype(ExtensionDtype):
    name: str
    base: Any
    type: type
    na_value: Any
    def numpy_dtype(self) -> np.dtype: ...
    def kind(self) -> str: ...
    def itemsize(self) -> int: ...
    @classmethod
    def construct_array_type(cls) -> type_t[BaseMaskedArray]: ...

class BaseMaskedArray(OpsMixin, ExtensionArray):
    def __init__(self, values: np.ndarray, mask: np.ndarray, copy: bool = ...) -> None: ...
    @property
    def dtype(self) -> BaseMaskedDtype: ...
    @overload
    def __getitem__(self, item: ScalarIndexer) -> Any: ...
    @overload
    def __getitem__(self, item: SequenceIndexer) -> BaseMaskedArrayT: ...
    def fillna(self, value: Any | None = ..., method: Any | None = ..., limit: Any | None = ...) -> BaseMaskedArrayT: ...
    def __setitem__(self, key, value) -> None: ...
    def __iter__(self): ...
    def __len__(self) -> int: ...
    @property
    def shape(self) -> Shape: ...
    @property
    def ndim(self) -> int: ...
    def swapaxes(self, axis1, axis2) -> BaseMaskedArrayT: ...
    def delete(self, loc, axis: int = ...) -> BaseMaskedArrayT: ...
    def reshape(self, *args, **kwargs) -> BaseMaskedArrayT: ...
    def ravel(self, *args, **kwargs) -> BaseMaskedArrayT: ...
    @property
    def T(self) -> BaseMaskedArrayT: ...
    def __invert__(self) -> BaseMaskedArrayT: ...
    def to_numpy(self, dtype: Union[npt.DTypeLike, None] = ..., copy: bool = ..., na_value: Scalar = ...) -> np.ndarray: ...
    @overload
    def astype(self, dtype: npt.DTypeLike, copy: bool = ...) -> np.ndarray: ...
    @overload
    def astype(self, dtype: ExtensionDtype, copy: bool = ...) -> ExtensionArray: ...
    @overload
    def astype(self, dtype: AstypeArg, copy: bool = ...) -> ArrayLike: ...
    __array_priority__: int
    def __array__(self, dtype: Union[NpDtype, None] = ...) -> np.ndarray: ...
    def __array_ufunc__(self, ufunc: np.ufunc, method: str, *inputs, **kwargs): ...
    def __arrow_array__(self, type: Any | None = ...): ...
    def isna(self) -> np.ndarray: ...
    @property
    def nbytes(self) -> int: ...
    def take(self, indexer, *, allow_fill: bool = ..., fill_value: Union[Scalar, None] = ..., axis: int = ...) -> BaseMaskedArrayT: ...
    def isin(self, values) -> BooleanArray: ...
    def copy(self) -> BaseMaskedArrayT: ...
    def factorize(self, na_sentinel: int = ...) -> tuple[np.ndarray, ExtensionArray]: ...
    def value_counts(self, dropna: bool = ...) -> Series: ...
    def equals(self, other) -> bool: ...
    def sum(self, *, skipna: bool = ..., min_count: int = ..., axis: Union[int, None] = ..., **kwargs): ...
    def prod(self, *, skipna: bool = ..., min_count: int = ..., axis: Union[int, None] = ..., **kwargs): ...
    def min(self, *, skipna: bool = ..., axis: Union[int, None] = ..., **kwargs): ...
    def max(self, *, skipna: bool = ..., axis: Union[int, None] = ..., **kwargs): ...
    def any(self, *, skipna: bool = ..., **kwargs): ...
    def all(self, *, skipna: bool = ..., **kwargs): ...
