import numpy as np
from pandas._config import get_option as get_option
from pandas._libs import NaT as NaT, lib as lib
from pandas._libs.interval import Interval as Interval, IntervalMixin as IntervalMixin, VALID_CLOSED as VALID_CLOSED, intervals_to_interval_bounds as intervals_to_interval_bounds
from pandas._libs.missing import NA as NA
from pandas._typing import ArrayLike as ArrayLike, Dtype as Dtype, NpDtype as NpDtype, PositionalIndexer as PositionalIndexer, ScalarIndexer as ScalarIndexer, SequenceIndexer as SequenceIndexer, npt as npt
from pandas.core.algorithms import isin as isin, take as take, unique as unique, value_counts as value_counts
from pandas.core.arrays.base import ExtensionArray as ExtensionArray
from pandas.core.construction import ensure_wrapped_if_datetimelike as ensure_wrapped_if_datetimelike, extract_array as extract_array
from pandas.core.dtypes.common import is_categorical_dtype as is_categorical_dtype, is_datetime64_dtype as is_datetime64_dtype, is_datetime64tz_dtype as is_datetime64tz_dtype, is_dtype_equal as is_dtype_equal, is_float_dtype as is_float_dtype, is_integer_dtype as is_integer_dtype, is_interval_dtype as is_interval_dtype, is_list_like as is_list_like, is_object_dtype as is_object_dtype, is_scalar as is_scalar, is_string_dtype as is_string_dtype, is_timedelta64_dtype as is_timedelta64_dtype, needs_i8_conversion as needs_i8_conversion, pandas_dtype as pandas_dtype
from pandas.core.dtypes.dtypes import IntervalDtype as IntervalDtype
from pandas.core.dtypes.generic import ABCDataFrame as ABCDataFrame, ABCDatetimeIndex as ABCDatetimeIndex, ABCIntervalIndex as ABCIntervalIndex, ABCPeriodIndex as ABCPeriodIndex
from pandas.core.dtypes.missing import is_valid_na_for_dtype as is_valid_na_for_dtype, isna as isna, notna as notna
from pandas.core.indexers import check_array_indexer as check_array_indexer
from pandas.core.indexes.base import ensure_index as ensure_index
from pandas.core.ops import invalid_comparison as invalid_comparison, unpack_zerodim_and_defer as unpack_zerodim_and_defer
from pandas.util._decorators import Appender as Appender
from typing import Union, Any, Sequence, TypeVar, Union, overload

IntervalArrayT = TypeVar('IntervalArrayT', bound='IntervalArray')
IntervalOrNA = Union[Interval, float]

class IntervalArray(IntervalMixin, ExtensionArray):
    ndim: int
    can_hold_na: bool
    def __new__(cls, data, closed: Any | None = ..., dtype: Union[Dtype, None] = ..., copy: bool = ..., verify_integrity: bool = ...): ...
    @classmethod
    def from_breaks(cls, breaks, closed: str = ..., copy: bool = ..., dtype: Union[Dtype, None] = ...) -> IntervalArrayT: ...
    @classmethod
    def from_arrays(cls, left, right, closed: str = ..., copy: bool = ..., dtype: Union[Dtype, None] = ...) -> IntervalArrayT: ...
    @classmethod
    def from_tuples(cls, data, closed: str = ..., copy: bool = ..., dtype: Union[Dtype, None] = ...) -> IntervalArrayT: ...
    @property
    def dtype(self) -> IntervalDtype: ...
    @property
    def nbytes(self) -> int: ...
    @property
    def size(self) -> int: ...
    def __iter__(self): ...
    def __len__(self) -> int: ...
    @overload
    def __getitem__(self, key: ScalarIndexer) -> IntervalOrNA: ...
    @overload
    def __getitem__(self, key: SequenceIndexer) -> IntervalArrayT: ...
    def __setitem__(self, key, value) -> None: ...
    def __eq__(self, other): ...
    def __ne__(self, other): ...
    def __gt__(self, other): ...
    def __ge__(self, other): ...
    def __lt__(self, other): ...
    def __le__(self, other): ...
    def argsort(self, ascending: bool = ..., kind: str = ..., na_position: str = ..., *args, **kwargs) -> np.ndarray: ...
    def min(self, *, axis: Union[int, None] = ..., skipna: bool = ...): ...
    def max(self, *, axis: Union[int, None] = ..., skipna: bool = ...): ...
    def fillna(self, value: Any | None = ..., method: Any | None = ..., limit: Any | None = ...) -> IntervalArrayT: ...
    def astype(self, dtype, copy: bool = ...): ...
    def equals(self, other) -> bool: ...
    def copy(self) -> IntervalArrayT: ...
    def isna(self) -> np.ndarray: ...
    def shift(self, periods: int = ..., fill_value: object = ...) -> IntervalArray: ...
    def take(self, indices, *, allow_fill: bool = ..., fill_value: Any | None = ..., axis: Any | None = ..., **kwargs) -> IntervalArrayT: ...
    def value_counts(self, dropna: bool = ...): ...
    @property
    def left(self): ...
    @property
    def right(self): ...
    @property
    def length(self): ...
    @property
    def mid(self): ...
    def overlaps(self, other): ...
    @property
    def closed(self): ...
    def set_closed(self, closed) -> IntervalArrayT: ...
    @property
    def is_non_overlapping_monotonic(self) -> bool: ...
    def __array__(self, dtype: Union[NpDtype, None] = ...) -> np.ndarray: ...
    def __arrow_array__(self, type: Any | None = ...): ...
    def to_tuples(self, na_tuple: bool = ...) -> np.ndarray: ...
    def insert(self, loc: int, item: Interval) -> IntervalArrayT: ...
    def delete(self, loc) -> IntervalArrayT: ...
    def repeat(self, repeats: Union[int, Sequence[int]], axis: Union[int, None] = ...) -> IntervalArrayT: ...
    def contains(self, other): ...
    def isin(self, values) -> np.ndarray: ...
    def unique(self) -> IntervalArray: ...
