import numpy as np
import pyarrow
from pandas._libs import lib as lib
from pandas._typing import ArrayLike as ArrayLike, AstypeArg as AstypeArg, Dtype as Dtype, DtypeObj as DtypeObj, npt as npt, type_t as type_t
from pandas.core import ops as ops
from pandas.core.arrays import ExtensionArray as ExtensionArray
from pandas.core.arrays.masked import BaseMaskedArray as BaseMaskedArray, BaseMaskedDtype as BaseMaskedDtype
from pandas.core.dtypes.common import is_bool_dtype as is_bool_dtype, is_float_dtype as is_float_dtype, is_integer_dtype as is_integer_dtype, is_list_like as is_list_like, is_numeric_dtype as is_numeric_dtype, pandas_dtype as pandas_dtype
from pandas.core.dtypes.dtypes import ExtensionDtype as ExtensionDtype, register_extension_dtype as register_extension_dtype
from pandas.core.dtypes.missing import isna as isna
from typing import Union, Any, overload

class BooleanDtype(BaseMaskedDtype):
    name: str
    @property
    def type(self) -> type: ...
    @property
    def kind(self) -> str: ...
    @property
    def numpy_dtype(self) -> np.dtype: ...
    @classmethod
    def construct_array_type(cls) -> type_t[BooleanArray]: ...
    def __from_arrow__(self, array: Union[pyarrow.Array, pyarrow.ChunkedArray]) -> BooleanArray: ...

def coerce_to_array(values, mask: Any | None = ..., copy: bool = ...) -> tuple[np.ndarray, np.ndarray]: ...

class BooleanArray(BaseMaskedArray):
    def __init__(self, values: np.ndarray, mask: np.ndarray, copy: bool = ...) -> None: ...
    @property
    def dtype(self) -> BooleanDtype: ...
    @overload
    def astype(self, dtype: npt.DTypeLike, copy: bool = ...) -> np.ndarray: ...
    @overload
    def astype(self, dtype: ExtensionDtype, copy: bool = ...) -> ExtensionArray: ...
    @overload
    def astype(self, dtype: AstypeArg, copy: bool = ...) -> ArrayLike: ...
    def __abs__(self): ...
