import numpy as np
from pandas._libs import lib as lib
from pandas._typing import ArrayLike as ArrayLike, AstypeArg as AstypeArg, Dtype as Dtype, FillnaOptions as FillnaOptions, NumpySorter as NumpySorter, NumpyValueArrayLike as NumpyValueArrayLike, PositionalIndexer as PositionalIndexer, ScalarIndexer as ScalarIndexer, SequenceIndexer as SequenceIndexer, Shape as Shape, TakeIndexer as TakeIndexer, npt as npt
from pandas.compat import set_function_name as set_function_name
from pandas.core import arraylike as arraylike, missing as missing, roperator as roperator
from pandas.core.algorithms import factorize_array as factorize_array, isin as isin, mode as mode, rank as rank, unique as unique
from pandas.core.array_algos.quantile import quantile_with_mask as quantile_with_mask
from pandas.core.dtypes.cast import maybe_cast_to_extension_array as maybe_cast_to_extension_array
from pandas.core.dtypes.common import is_dtype_equal as is_dtype_equal, is_list_like as is_list_like, is_scalar as is_scalar, pandas_dtype as pandas_dtype
from pandas.core.dtypes.dtypes import ExtensionDtype as ExtensionDtype
from pandas.core.dtypes.generic import ABCDataFrame as ABCDataFrame, ABCIndex as ABCIndex, ABCSeries as ABCSeries
from pandas.core.dtypes.missing import isna as isna
from pandas.core.sorting import nargminmax as nargminmax, nargsort as nargsort
from pandas.errors import AbstractMethodError as AbstractMethodError
from pandas.util._decorators import Appender as Appender, Substitution as Substitution, cache_readonly as cache_readonly
from pandas.util._validators import validate_bool_kwarg as validate_bool_kwarg, validate_fillna_kwargs as validate_fillna_kwargs, validate_insert_loc as validate_insert_loc
from typing import Union, Any, Iterator, Literal, Sequence, TypeVar, overload

class ExtensionArraySupportsAnyAll:
    def any(self, *, skipna: bool = ...) -> bool: ...
    def all(self, *, skipna: bool = ...) -> bool: ...
ExtensionArrayT = TypeVar('ExtensionArrayT', bound='ExtensionArray')

class ExtensionArray:
    @overload
    def __getitem__(self, item: ScalarIndexer) -> Any: ...
    @overload
    def __getitem__(self, item: SequenceIndexer) -> ExtensionArrayT: ...
    def __setitem__(self, key: Union[int, slice, np.ndarray], value: Any) -> None: ...
    def __len__(self) -> int: ...
    def __iter__(self) -> Iterator[Any]: ...
    def __contains__(self, item: object) -> Union[bool, np.bool_]: ...
    def __eq__(self, other: Any) -> ArrayLike: ...
    def __ne__(self, other: Any) -> ArrayLike: ...
    def to_numpy(self, dtype: Union[npt.DTypeLike, None] = ..., copy: bool = ..., na_value=...) -> np.ndarray: ...
    @property
    def dtype(self) -> ExtensionDtype: ...
    @property
    def shape(self) -> Shape: ...
    @property
    def size(self) -> int: ...
    @property
    def ndim(self) -> int: ...
    @property
    def nbytes(self) -> int: ...
    @overload
    def astype(self, dtype: npt.DTypeLike, copy: bool = ...) -> np.ndarray: ...
    @overload
    def astype(self, dtype: ExtensionDtype, copy: bool = ...) -> ExtensionArray: ...
    @overload
    def astype(self, dtype: AstypeArg, copy: bool = ...) -> ArrayLike: ...
    def isna(self) -> Union[np.ndarray, ExtensionArraySupportsAnyAll]: ...
    def argsort(self, ascending: bool = ..., kind: str = ..., na_position: str = ..., *args, **kwargs) -> np.ndarray: ...
    def argmin(self, skipna: bool = ...) -> int: ...
    def argmax(self, skipna: bool = ...) -> int: ...
    def fillna(self, value: Union[object, ArrayLike, None] = ..., method: Union[FillnaOptions, None] = ..., limit: Union[int, None] = ...): ...
    def dropna(self) -> ExtensionArrayT: ...
    def shift(self, periods: int = ..., fill_value: object = ...) -> ExtensionArray: ...
    def unique(self) -> ExtensionArrayT: ...
    def searchsorted(self, value: Union[NumpyValueArrayLike, ExtensionArray], side: Literal[left, right] = ..., sorter: NumpySorter = ...) -> Union[npt.NDArray[np.intp], np.intp]: ...
    def equals(self, other: object) -> bool: ...
    def isin(self, values) -> np.ndarray: ...
    def factorize(self, na_sentinel: int = ...) -> tuple[np.ndarray, ExtensionArray]: ...
    def repeat(self, repeats: Union[int, Sequence[int]], axis: Union[int, None] = ...): ...
    def take(self, indices: TakeIndexer, *, allow_fill: bool = ..., fill_value: Any = ...) -> ExtensionArrayT: ...
    def copy(self) -> ExtensionArrayT: ...
    def view(self, dtype: Union[Dtype, None] = ...) -> ArrayLike: ...
    def transpose(self, *axes: int) -> ExtensionArray: ...
    @property
    def T(self) -> ExtensionArray: ...
    def ravel(self, order: Union[Literal[C, F, A, K], None] = ...) -> ExtensionArray: ...
    __hash__: None
    def tolist(self) -> list: ...
    def delete(self, loc: PositionalIndexer) -> ExtensionArrayT: ...
    def insert(self, loc: int, item) -> ExtensionArrayT: ...
    def __array_ufunc__(self, ufunc: np.ufunc, method: str, *inputs, **kwargs): ...

class ExtensionOpsMixin: ...
class ExtensionScalarOpsMixin(ExtensionOpsMixin): ...
