import numpy as np
from datetime import date as _date, datetime, time as _time, timedelta, tzinfo as _tzinfo
from pandas._libs.tslibs import BaseOffset as BaseOffset, NaTType as NaTType, Period as Period, Timedelta as Timedelta
from time import struct_time as struct_time
from typing import Union, ClassVar, overload

def integer_op_not_supported(obj: object) -> TypeError: ...

class Timestamp(datetime):
    min: ClassVar[Timestamp]
    max: ClassVar[Timestamp]
    resolution: ClassVar[Timedelta]
    value: int
    def __new__(cls, ts_input: Union[int, np.integer, float, str, _date, datetime, np.datetime64] = ..., freq: Union[int, None, str, BaseOffset] = ..., tz: Union[str, _tzinfo, None, int] = ..., unit: Union[str, int, None] = ..., year: Union[int, None] = ..., month: Union[int, None] = ..., day: Union[int, None] = ..., hour: Union[int, None] = ..., minute: Union[int, None] = ..., second: Union[int, None] = ..., microsecond: Union[int, None] = ..., nanosecond: Union[int, None] = ..., tzinfo: Union[_tzinfo, None] = ..., *, fold: Union[int, None] = ...) -> Union[_DatetimeT, NaTType]: ...
    @property
    def year(self) -> int: ...
    @property
    def month(self) -> int: ...
    @property
    def day(self) -> int: ...
    @property
    def hour(self) -> int: ...
    @property
    def minute(self) -> int: ...
    @property
    def second(self) -> int: ...
    @property
    def microsecond(self) -> int: ...
    @property
    def tzinfo(self) -> Union[_tzinfo, None]: ...
    @property
    def tz(self) -> Union[_tzinfo, None]: ...
    @property
    def fold(self) -> int: ...
    @classmethod
    def fromtimestamp(cls, t: float, tz: Union[_tzinfo, None] = ...) -> _DatetimeT: ...
    @classmethod
    def utcfromtimestamp(cls, t: float) -> _DatetimeT: ...
    @classmethod
    def today(cls, tz: Union[_tzinfo, str, None] = ...) -> _DatetimeT: ...
    @classmethod
    def fromordinal(cls, ordinal: int, freq: Union[str, BaseOffset, None] = ..., tz: Union[_tzinfo, str, None] = ...) -> _DatetimeT: ...
    @classmethod
    def now(cls, tz: Union[_tzinfo, str, None] = ...) -> _DatetimeT: ...
    @classmethod
    def utcnow(cls) -> _DatetimeT: ...
    @classmethod
    def combine(cls, date: _date, time: _time) -> datetime: ...
    @classmethod
    def fromisoformat(cls, date_string: str) -> _DatetimeT: ...
    def strftime(self, format: str) -> str: ...
    def __format__(self, fmt: str) -> str: ...
    def toordinal(self) -> int: ...
    def timetuple(self) -> struct_time: ...
    def timestamp(self) -> float: ...
    def utctimetuple(self) -> struct_time: ...
    def date(self) -> _date: ...
    def time(self) -> _time: ...
    def timetz(self) -> _time: ...
    def replace(self, year: int = ..., month: int = ..., day: int = ..., hour: int = ..., minute: int = ..., second: int = ..., microsecond: int = ..., tzinfo: Union[_tzinfo, None] = ..., fold: int = ...) -> datetime: ...
    def astimezone(self, tz: Union[_tzinfo, None] = ...) -> _DatetimeT: ...
    def ctime(self) -> str: ...
    def isoformat(self, sep: str = ..., timespec: str = ...) -> str: ...
    @classmethod
    def strptime(cls, date_string: str, format: str) -> datetime: ...
    def utcoffset(self) -> Union[timedelta, None]: ...
    def tzname(self) -> Union[str, None]: ...
    def dst(self) -> Union[timedelta, None]: ...
    def __le__(self, other: datetime) -> bool: ...
    def __lt__(self, other: datetime) -> bool: ...
    def __ge__(self, other: datetime) -> bool: ...
    def __gt__(self, other: datetime) -> bool: ...
    @overload
    def __add__(self, other: np.ndarray) -> np.ndarray: ...
    @overload
    def __add__(self, other: Union[timedelta, np.timedelta64]) -> _DatetimeT: ...
    def __radd__(self, other: timedelta) -> _DatetimeT: ...
    @overload
    def __sub__(self, other: datetime) -> timedelta: ...
    @overload
    def __sub__(self, other: Union[timedelta, np.timedelta64]) -> datetime: ...
    def __hash__(self) -> int: ...
    def weekday(self) -> int: ...
    def isoweekday(self) -> int: ...
    def isocalendar(self) -> tuple[int, int, int]: ...
    @property
    def is_leap_year(self) -> bool: ...
    @property
    def is_month_start(self) -> bool: ...
    @property
    def is_quarter_start(self) -> bool: ...
    @property
    def is_year_start(self) -> bool: ...
    @property
    def is_month_end(self) -> bool: ...
    @property
    def is_quarter_end(self) -> bool: ...
    @property
    def is_year_end(self) -> bool: ...
    def to_pydatetime(self, warn: bool = ...) -> datetime: ...
    def to_datetime64(self) -> np.datetime64: ...
    def to_period(self, freq: Union[BaseOffset, str, None] = ...) -> Period: ...
    def to_julian_date(self) -> np.float64: ...
    @property
    def asm8(self) -> np.datetime64: ...
    def tz_convert(self, tz: Union[_tzinfo, str, None]) -> _DatetimeT: ...
    def tz_localize(self, tz: Union[_tzinfo, str, None], ambiguous: str = ..., nonexistent: str = ...) -> _DatetimeT: ...
    def normalize(self) -> _DatetimeT: ...
    def round(self, freq: str, ambiguous: Union[bool, str] = ..., nonexistent: str = ...) -> _DatetimeT: ...
    def floor(self, freq: str, ambiguous: Union[bool, str] = ..., nonexistent: str = ...) -> _DatetimeT: ...
    def ceil(self, freq: str, ambiguous: Union[bool, str] = ..., nonexistent: str = ...) -> _DatetimeT: ...
    def day_name(self, locale: Union[str, None] = ...) -> str: ...
    def month_name(self, locale: Union[str, None] = ...) -> str: ...
    @property
    def day_of_week(self) -> int: ...
    @property
    def day_of_month(self) -> int: ...
    @property
    def day_of_year(self) -> int: ...
    @property
    def quarter(self) -> int: ...
    @property
    def week(self) -> int: ...
    def to_numpy(self, dtype: Union[np.dtype, None] = ..., copy: bool = ...) -> np.datetime64: ...
