import numpy as np
from pandas._libs.tslibs.nattype import NaTType as NaTType
from pandas._libs.tslibs.offsets import BaseOffset as BaseOffset
from pandas._libs.tslibs.timestamps import Timestamp as Timestamp
from pandas._typing import Frequency as Frequency, Timezone as Timezone, npt as npt
from typing import Union, Literal

INVALID_FREQ_ERR_MSG: str
DIFFERENT_FREQ: str

class IncompatibleFrequency(ValueError): ...

def periodarr_to_dt64arr(periodarr: npt.NDArray[np.int64], freq: int) -> npt.NDArray[np.int64]: ...
def period_asfreq_arr(arr: npt.NDArray[np.int64], freq1: int, freq2: int, end: bool) -> npt.NDArray[np.int64]: ...
def get_period_field_arr(field: str, arr: npt.NDArray[np.int64], freq: int) -> npt.NDArray[np.int64]: ...
def from_ordinals(values: npt.NDArray[np.int64], freq: Frequency) -> npt.NDArray[np.int64]: ...
def extract_ordinals(values: npt.NDArray[np.object_], freq: Union[Frequency, int]) -> npt.NDArray[np.int64]: ...
def extract_freq(values: npt.NDArray[np.object_]) -> BaseOffset: ...
def period_asfreq(ordinal: int, freq1: int, freq2: int, end: bool) -> int: ...
def period_ordinal(y: int, m: int, d: int, h: int, min: int, s: int, us: int, ps: int, freq: int) -> int: ...
def freq_to_dtype_code(freq: BaseOffset) -> int: ...
def validate_end_alias(how: str) -> Literal[E, S]: ...

class Period:
    ordinal: int
    freq: BaseOffset
    def __new__(cls, value=..., freq: Union[int, str, None] = ..., ordinal: Union[int, None] = ..., year: Union[int, None] = ..., month: Union[int, None] = ..., quarter: Union[int, None] = ..., day: Union[int, None] = ..., hour: Union[int, None] = ..., minute: Union[int, None] = ..., second: Union[int, None] = ...) -> Union[Period, NaTType]: ...
    @classmethod
    def now(cls, freq: BaseOffset = ...) -> Period: ...
    def strftime(self, fmt: str) -> str: ...
    def to_timestamp(self, freq: Union[str, BaseOffset, None] = ..., how: str = ..., tz: Union[Timezone, None] = ...) -> Timestamp: ...
    def asfreq(self, freq: str, how: str = ...) -> Period: ...
    @property
    def freqstr(self) -> str: ...
    @property
    def is_leap_year(self) -> bool: ...
    @property
    def daysinmonth(self) -> int: ...
    @property
    def days_in_month(self) -> int: ...
    @property
    def qyear(self) -> int: ...
    @property
    def quarter(self) -> int: ...
    @property
    def day_of_year(self) -> int: ...
    @property
    def weekday(self) -> int: ...
    @property
    def day_of_week(self) -> int: ...
    @property
    def week(self) -> int: ...
    @property
    def weekofyear(self) -> int: ...
    @property
    def second(self) -> int: ...
    @property
    def minute(self) -> int: ...
    @property
    def hour(self) -> int: ...
    @property
    def day(self) -> int: ...
    @property
    def month(self) -> int: ...
    @property
    def year(self) -> int: ...
    @property
    def end_time(self) -> Timestamp: ...
    @property
    def start_time(self) -> Timestamp: ...
    def __sub__(self, other) -> Union[Period, BaseOffset]: ...
    def __add__(self, other) -> Period: ...
